package com.biz.crm.cps.mobile.terminal.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.participator.sdk.dto.TerminalPaginationDto;
import com.biz.crm.cps.mobile.terminal.service.TerminalManageVoService;
import com.biz.crm.cps.mobile.terminal.vo.TerminalManageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 终端管理控制器
 * @Author dy
 * @DATE 2022/3/24
 **/
@Api(tags = "终端管理:TerminalManageVo:终端管理")
@Slf4j
@RestController
@RequestMapping("/v1/mobile/terminalManage")
public class TerminalManageVoController {

  @Autowired
  private TerminalManageVoService terminalManageVoService;

  /**
   * 通过查询条件查询终端信息,包含终端的分利信息
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "通过查询条件查询终端信息,包含终端的分利信息")
  @GetMapping(value = "/findByConditions")
  public Result<Page<TerminalManageVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                         @ApiParam(name = "dto", value = "终端分页查询dto") TerminalPaginationDto dto) {
    try {
      Page<TerminalManageVo> page = terminalManageVoService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
