package com.biz.crm.cps.mobile.terminal.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**扫码记录报表-分页查询dto
 * @Author dy
 * @DATE 2022/4/14
 **/
@Data
@ApiModel(value = "ScanCodeRecordReportAllPaginationDto", description = "扫码记录报表-分页查询dto")
public class ScanCodeRecordReportAllPaginationDto {

  /** 参与者类型：(c-经销商，terminal-终端用户，consumer-消费者) */
  @ApiModelProperty(value = "参与者类型：(c-经销商，terminal-终端用户，consumer-消费者,user_guide-导购)", hidden = true)
  private String participatorType;

  /** 码流转参与者编码 */
  @ApiModelProperty(value = "码流转参与者编码",hidden = true)
  private String scanParticipatorCode;

  /** 码 */
  @ApiModelProperty(value = "码")
  private String barCode;

  /** 物料名称 */
  @ApiModelProperty("物料名称")
  private String productName;

  /**
   * 扫码类型：1-入库，2-开单，3-抽奖
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanTypeEnum
   */
  @ApiModelProperty("扫码类型：1-入库，2-开单，3-抽奖")
  private String scanType;

  /**
   * 扫码时间
   */
  @ApiModelProperty("扫码时间")
  @DateTimeFormat(pattern = "yyyy-MM")
  private Date createTime;


  /** 操作时间 */
  @ApiModelProperty(value = "操作时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createStartTime;

  /** 操作时间 */
  @ApiModelProperty(value = "操作时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createEndTime;
}
