package com.biz.crm.cps.mobile.terminal.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 扫码记录报表
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeRecordReportDto", description = "扫码记录报表dto")
public class ScanCodeRecordReportDto {

  /**
   * 码
   */
  @ApiModelProperty("码")
  private String barCode;

  /**
   * 码类型：1-箱码，2-盒码，3-盖内码
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum
   */
  @ApiModelProperty("码类型：1-箱码，2-盒码，3-盖内码")
  private String barCodeType;

  /**
   * 扫码类型：1-入库，2-开单，3-抽奖，4-出库
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanTypeEnum
   */
  @ApiModelProperty("扫码类型：1-入库，2-开单，3-抽奖，4-出库")
  private String scanType;

  /**
   * 录入类型：1-手动，2-自动
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.EnterTypeEnum
   */
  @ApiModelProperty("录入类型：1-手动，2-自动")
  private String enterType;

  /**
   * 协议名称
   */
  @ApiModelProperty("协议名称")
  private String agreementName;

  /**
   * 参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)
   */
  @ApiModelProperty("参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)")
  private String participatorType;

  /**
   * 码流转参与者编码
   */
  @ApiModelProperty("码流转参与者编码")
  private String barCodeParticipatorCode;

  /**
   * 扫码人编码
   */
  @ApiModelProperty("扫码人编码")
  private String scanParticipatorCode;

  /**
   * 扫码时间
   */
  @ApiModelProperty("扫码时间")
  @DateTimeFormat(pattern = "yyyy-MM")
  private Date createTime;

  /**
   * 扫码时间开始
   */
  @ApiModelProperty("扫码时间开始")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeStart;

  /**
   * 扫码时间结束
   */
  @ApiModelProperty("扫码时间结束")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeEnd;

  /**
   * 条码和商品名称组合字段
   */
  @ApiModelProperty("条码和商品名称组合字段")
  private String productName;

  /**
   * 扫码编码集合
   */
  @ApiModelProperty("扫码编码集合")
  private List<String> recordCodes;

  /**
   * 关联政策类别
   */
  @ApiModelProperty("关联政策类别")
  private String policyType;
}
