package com.biz.crm.cps.mobile.terminal.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 扫码记录报表分页查询dto-导购
 *
 * @author sunx
 * @date 2022/3/24
 */
@Data
@ApiModel(value = "ScanCodeRecordReportGuidePaginationDto", description = "扫码记录报表-导购分页查询dto")
public class ScanCodeRecordReportGuidePaginationDto {

  /** 参与者类型：(c-经销商，terminal-终端用户，consumer-消费者) */
  @ApiModelProperty(value = "参与者类型：(c-经销商，terminal-终端用户，consumer-消费者,user_guide-导购)", hidden = true)
  private String participatorType;

  /** 码流转参与者编码 */
  @ApiModelProperty("码流转参与者编码")
  private String scanParticipatorCode;

  /** 码 */
  @ApiModelProperty(value = "码")
  private String barCode;

  /** 物料名称 */
  @ApiModelProperty("物料名称")
  private String productName;

  /** 操作时间 */
  @ApiModelProperty(value = "操作时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createStartTime;

  /** 操作时间 */
  @ApiModelProperty(value = "操作时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createEndTime;
}
