package com.biz.crm.cps.mobile.terminal.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.mobile.terminal.dto.CashRecordReportDto;
import com.biz.crm.cps.mobile.terminal.vo.CashRecordReportVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * 提现记录流水 数据层操作
 */
@Mapper
public interface CashRecordReportVoMapper {

  /**
   * 通过查询条件查询终端提现记录
   *
   * @param page
   * @param dto
   * @return
   */
  Page<CashRecordReportVo> findTerminalByConditions(@Param("page") Page<CashRecordReportVo> page, @Param("dto") CashRecordReportDto dto);

  /**
   * 通过查询条件查询经销商提现记录
   *
   * @param page
   * @param dto
   * @return
   */
  Page<CashRecordReportVo> findDealerByConditions(@Param("page") Page<CashRecordReportVo> page, @Param("dto") CashRecordReportDto dto);

  /**
   * 通过查询条件查询消费者提现记录
   *
   * @param page
   * @param dto
   * @return
   */
  Page<CashRecordReportVo> findConsumerByConditions(@Param("page") Page<CashRecordReportVo> page, @Param("dto") CashRecordReportDto dto);

  /**
   * 通过查询条件查询导购提现记录
   *
   * @param page
   * @param dto
   * @return
   */
  Page<CashRecordReportVo> findUserGuideByConditions(@Param("page") Page<CashRecordReportVo> page, @Param("dto") CashRecordReportDto dto);
}
