package com.biz.crm.cps.mobile.terminal.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.mobile.terminal.dto.ScanCodeRecordReportAllPaginationDto;
import com.biz.crm.cps.mobile.terminal.dto.ScanCodeRecordReportGuidePaginationDto;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordReportAllVo;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordReportGuideVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 扫码记录报表all
 * @author sunx
 * @date 2022/3/29
 */
public interface ScanCodeRecordReportAllVoMapper {

  /**
   * 扫码记录报表-导购
   *
   * @param page
   * @param dto
   * @param ltKey
   * @return
   */
  Page<ScanCodeRecordReportGuideVo> findUserGuideByConditions(
      Page<ScanCodeRecordReportGuideVo> page,
      @Param("dto") ScanCodeRecordReportGuidePaginationDto dto,
      @Param("ltKey") String ltKey);


  /**
   * 扫码记录
   * @param page
   * @param dto
   * @return
   */
  Page<ScanCodeRecordReportAllVo> findByConditions(Page<ScanCodeRecordReportAllVo> page, @Param("dto") ScanCodeRecordReportAllPaginationDto dto);

  /**
   * 查询扫码记录
   * @param dto
   * @return
   */
  List<ScanCodeRecordReportAllVo> findByConditions(@Param("dto") ScanCodeRecordReportAllPaginationDto dto);
}
