package com.biz.crm.cps.mobile.terminal.notifier;

import com.bizunited.nebula.security.sdk.event.AuthenticationCompetenceEventListener;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Set;

/**
 * @author songjingen
 */
@Slf4j
public class AuthenticationRbacEventListenerImpl implements AuthenticationCompetenceEventListener {

  @Override
  public Set<String> onRequestRoleCodes(List<RequestMappingInfo> matchedRequestMappings, String tenantCode, HttpServletRequest httpRequest) {
    // 因为已经当前登录者（通过head中的token来获得），所以这里返不返回信息已经不重要了，
    log.warn("=====================简单实现===========");
    return Sets.newHashSet("ADMIN");
  }

  @Override
  public Set<String> onRequestIgnoreMethodCheckRoles() {
    // 当鉴权模块需要返回“哪些角色编码时管理员角色时”，直接返回"ADMIN"
    return Sets.newHashSet("ADMIN");
  }
}
