package com.biz.crm.cps.mobile.terminal.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerDto;
import com.biz.crm.cps.mobile.terminal.mapper.ConsumerManageVoMapper;
import com.biz.crm.cps.mobile.terminal.vo.ConsumerManageVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 消费者管理控制器
 * @Author dy
 * @DATE 2022/4/1
 **/
@Component
public class ConsumerManageVoRepository {

  @Autowired
  private ConsumerManageVoMapper consumerManageVoMapper;


  /**
   * 分页条件查询
   * @param pageable
   * @param dto
   * @return
   */
  public Page<ConsumerManageVo> findByConditions(Pageable pageable, @Param("dto") ConsumerDto dto){
    Page<ConsumerManageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return consumerManageVoMapper.findByConditions(page, dto);
  }

}
