package com.biz.crm.cps.mobile.terminal.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.mobile.terminal.dto.ScanCodeRecordReportAllPaginationDto;
import com.biz.crm.cps.mobile.terminal.dto.ScanCodeRecordReportGuidePaginationDto;
import com.biz.crm.cps.mobile.terminal.mapper.ScanCodeRecordReportAllVoMapper;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordReportAllVo;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordReportGuideVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 扫码记录报表 - all
 *
 * @author sunx
 * @date 2022/3/29
 */
@Component
public class ScanCodeRecordReportAllVoRepository {

  @Autowired private ScanCodeRecordReportAllVoMapper scanCodeRecordReportAllVoMapper;

  /**
   * 扫码记录报表-导购
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<ScanCodeRecordReportGuideVo> findUserGuideByConditions(
      Pageable pageable, ScanCodeRecordReportGuidePaginationDto dto) {
    Page<ScanCodeRecordReportGuideVo> page =
        new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.scanCodeRecordReportAllVoMapper.findUserGuideByConditions(
        page, dto, ScanCodeExceptionEnum.NO_ACTIVITY.getCode());
  }


  /**
   * 分页查询扫码记录
   * @param pageable
   * @param dto
   * @return
   */
  public Page<ScanCodeRecordReportAllVo> findByConditions(Pageable pageable, ScanCodeRecordReportAllPaginationDto dto){
    Page<ScanCodeRecordReportAllVo> page = new Page<>(pageable.getPageNumber(),pageable.getPageSize());
    return this.scanCodeRecordReportAllVoMapper.findByConditions(page,dto);
  }

  /**
   * 查询扫码记录
   * @param dto
   * @return
   */
  public List<ScanCodeRecordReportAllVo> findByConditions(ScanCodeRecordReportAllPaginationDto dto){
    return this.scanCodeRecordReportAllVoMapper.findByConditions(dto);
  }
}
