package com.biz.crm.cps.mobile.terminal.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.mobile.terminal.dto.ScanCodeRecordReportDto;
import com.biz.crm.cps.mobile.terminal.mapper.ScanCodeRecordReportVoMapper;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordReportVo;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 扫码记录报表相关数据库操作
 * @author songjingen
 */
@Component
public class ScanCodeRecordReportVoRepository {

  @Resource
  private ScanCodeRecordReportVoMapper scanCodeRecordReportMapper;


  /**
   * 通过查询条件查询当前参与者的扫码记录分页信息
   * @param pageable
   * @param dto
   * @return
   */
  public Page<ScanCodeRecordReportVo> findByConditions(Pageable pageable, ScanCodeRecordReportDto dto) {
    Page<ScanCodeRecordReportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<ScanCodeRecordReportVo> voPage = scanCodeRecordReportMapper.findByConditions(page, dto);
    return voPage;
  }

  /**
   * 通过查询条件查询当前参与者的扫码记录信息
   * @param dto
   * @return
   */
  public List<ScanCodeRecordReportVo> findByConditions(ScanCodeRecordReportDto dto) {
    return scanCodeRecordReportMapper.findByConditions(dto);
  }
}
