package com.biz.crm.cps.mobile.terminal.service;

import com.biz.crm.cps.business.reward.sdk.vo.RewardRelAgreementVo;
import java.util.List;

/**
 * 分利协议汇总奖励报表
 * <pre>
 *   汇总各个具体奖励模块参与者的模版编码奖励信息
 *   包含 模版编码和其对应的奖励汇总
 *   [
 *   {
 *     "templateCode": "patc0478",
 *     "rewardTypeStatisticsVos": [
 *       {
 *         "name": "红包",
 *         "flag": "1",
 *         "key": "redpacket",
 *         "amount": 14.6,
 *         "balance": null
 *       },
 *       {
 *         "name": "积分",
 *         "flag": "2",
 *         "key": "integral",
 *         "amount": 110,
 *         "balance": null
 *       },
 *       {
 *         "name": "费用",
 *         "flag": "3",
 *         "key": "cost",
 *         "amount": 0,
 *         "balance": null
 *       }
 *     ]
 *   }
 * ]
 * </pre>
 *
 * @author hecheng
 */
public interface RewardRelAgreementVoService {


  /**
   * 通过参与者 和模版编码查询 获利汇总
   *
   * @param participatorCode
   * @param templateCodes
   * @return
   */
  List<RewardRelAgreementVo> findByParticipatorCodeAndTemplateCodes(String participatorCode, List<String> templateCodes);
}
