package com.biz.crm.cps.mobile.terminal.service;

import com.biz.crm.cps.business.reward.sdk.vo.RewardRelParticipatorVo;
import java.util.List;

/**
 * 参与者奖励报表
 * <pre>
 *   汇总各个具体奖励模块参与者的奖励信息
 *   包含 参与者编码和其对应的奖励汇总
 *   [
 *   {
 *     "participatorCode": "SF3432543643",
 *     "rewardTypeStatisticsVos": [
 *       {
 *         "name": "红包",
 *         "flag": "1",
 *         "key": "redpacket",
 *         "amount": 33.1,
 *         "balance": 33.1
 *       },
 *       {
 *         "name": "积分",
 *         "flag": "2",
 *         "key": "integral",
 *         "amount": 258,
 *         "balance": 258
 *       },
 *       {
 *         "name": "费用",
 *         "flag": "3",
 *         "key": "cost",
 *         "amount": 38.5,
 *         "balance": 38.5
 *       }
 *     ]
 *   }
 * ]
 * </pre>
 * @author hecheng
 */
public interface RewardRelParticipatorVoService {
  /**
   * 通过参与者 查询 获利汇总
   *
   * @param participatorCodes
   * @return
   */
  List<RewardRelParticipatorVo> findByParticipatorCodes(List<String> participatorCodes);
}
