package com.biz.crm.cps.mobile.terminal.service;

import com.biz.crm.cps.business.reward.sdk.vo.RewardRelScanCodeVo;
import java.util.List;

/**
 * 扫码奖励汇总
 * <pre>
 *   汇总各个具体奖励模块参与者的扫码奖励信息
 *   包含 扫码编码和其对应的奖励汇总
 *   [
 *   {
 *     "recordCode": "SM000531",
 *     "templateCodes": [
 *       "patc0478"
 *     ],
 *     "policyNames": [
 *       "扫码政策"
 *     ],
 *     "policyNameStr": "扫码政策",
 *     "agreementNames": "扫码模板-演示1-终端信息_演示",
 *     "rewardStatisticsVo": {
 *       "name": "红包",
 *       "flag": "1",
 *       "key": "redpacket",
 *       "amount": 1.7,
 *       "balance": null
 *     }
 *   },
 *   {
 *     "recordCode": "SM000531",
 *     "templateCodes": [
 *       "patc0478"
 *     ],
 *     "policyNames": [
 *       "扫码政策"
 *     ],
 *     "policyNameStr": "扫码政策",
 *     "agreementNames": "扫码模板-演示1-终端信息_演示",
 *     "rewardStatisticsVo": {
 *       "name": "积分",
 *       "flag": "2",
 *       "key": "integral",
 *       "amount": 14,
 *       "balance": null
 *     }
 *   }
 * ]
 *
 * </pre>
 *
 * @author hecheng
 */
public interface RewardRelScanCodeVoService {

  /**
   * 通过参与者 和扫码编码 查询分利信息集合
   *
   * @param participatorCode
   * @param recordCodes
   * @return
   */
  List<RewardRelScanCodeVo> findByParticipatorCodeAndRecordCodes(String participatorCode, String participatorType, List<String> recordCodes);
}
