package com.biz.crm.cps.mobile.terminal.service;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import java.util.List;

/**
 * 奖励汇总报表
 * <pre>
 *   汇总各个具体奖励模块的奖励信息
 *   包含 奖励的名字，类型，标志、金额等
 * 示例：
 *[
 *   {
 *     "name": "红包",
 *     "flag": "1",
 *     "key": "redpacket",
 *     "amount": 0,
 *     "balance": null
 *   },
 *   {
 *     "name": "积分",
 *     "flag": "2",
 *     "key": "integral",
 *     "amount": 0,
 *     "balance": null
 *   },
 *   {
 *     "name": "费用",
 *     "flag": "3",
 *     "key": "cost",
 *     "amount": 0,
 *     "balance": null
 *   }
 * ]
 * </pre>
 *
 * @author hecheng
 */
public interface RewardTypeStatisticsVoService {


  /**
   * 通过参与者 和扫码记录查询 获利汇总
   *
   * @param participatorCode
   * @param recordCodes
   * @return
   */
  List<RewardTypeStatisticsVo> findByParticipatorCodeAndRecordCodes(String participatorCode, List<String> recordCodes);
  /**
   * 通过租户 和触发动作 查询 获利汇总
   *
   * @param tenantCode
   * @param triggerAction
   * @return
   */
  List<RewardTypeStatisticsVo> findByTenantCodeAndTriggerAction(String tenantCode, String triggerAction);

}
