package com.biz.crm.cps.mobile.terminal.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.mobile.terminal.dto.ScanCodeRecordReportAllPaginationDto;
import com.biz.crm.cps.mobile.terminal.dto.ScanCodeRecordReportGuidePaginationDto;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordReportAllVo;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordReportGuideVo;
import org.springframework.data.domain.Pageable;

/**
 * 扫码记录all 接口
 *
 * @author sunx
 * @date 2022/3/29
 */
public interface ScanCodeRecordReportAllVoService {

  /**
   * 导购扫码记录新报表
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<ScanCodeRecordReportGuideVo> findUserGuideByConditions(
      Pageable pageable, ScanCodeRecordReportGuidePaginationDto dto);


  /**
   * 扫码记录新报表 --经销商，终端
   * @param dto
   * @return
   */
  Page<ScanCodeRecordReportAllVo> findByConditions(Pageable pageable, ScanCodeRecordReportAllPaginationDto dto);
}
