package com.biz.crm.cps.mobile.terminal.service;

import com.biz.crm.cps.mobile.terminal.dto.ScanCodeRecordReportDto;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeReachVo;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeStatisticsVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 扫码记录报表service
 *
 * @author songjingen
 */
public interface ScanCodeRecordReportVoService {

  /**
   * 通过查询条件查询当前参与者的扫码记录分页信息
   *
   * @param pageable
   * @param dto
   * @return
   */
  ScanCodeStatisticsVo findByConditions(Pageable pageable, ScanCodeRecordReportDto dto);

  /**
   * 查询指定终端当月的扫码目标和达成率
   * @param dateType 年度\月度
   * @return
   */
  List<ScanCodeReachVo> findScanTargetAndReach(String dateType);
}
