package com.biz.crm.cps.mobile.terminal.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import com.biz.crm.cps.business.agreement.local.entity.AgreementSign;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplate;
import com.biz.crm.cps.business.agreement.local.entity.TemplatePolicyRelationship;
import com.biz.crm.cps.business.agreement.local.service.AgreementService;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignatoryEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementDto;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelAgreementVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.biz.crm.cps.mobile.terminal.service.AgreementReportVoService;
import com.biz.crm.cps.mobile.terminal.service.RewardRelAgreementVoService;
import com.biz.crm.cps.mobile.terminal.vo.AgreementReportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 分利协议信息报表Service实现类
 * @author songjingen
 */
@Service
@Slf4j
public class AgreementReportVoServiceImpl implements AgreementReportVoService {

  @Autowired
  private AgreementService agreementService;
  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private LoginUserService loginUserService;
  @Autowired
  private RewardRelAgreementVoService rewardRelAgreementVoService;

  /**
   * H5的分利信息查询信息
   * @param pageable
   * @param dto
   * @return
   */
  @Override
  public Page<AgreementReportVo> findByConditions(Pageable pageable, AgreementDto dto) {
    /**
     * 1、查询当前登录信息
     * 2、查询协议信息
     * 3、查询收益信息
     * 4、模板信息和签署记录信息的属性赋值到协议报表中
     * 5、收益情况赋值到协议报表中
     */
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if(dto == null) {
      dto = new AgreementDto();
    }
    //判断用户是否登录
    LoginUserDetailsForCPS loginUser = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    log.info("当前登录用户信息：" + loginUser);
    if (Objects.isNull(loginUser)) {
      return null;
    }
    if (ParticipatorTypeEnum.DEALER.getKey().equals(loginUser.getUsertype())) {
      dto.setCustomerCode(loginUser.getConsumerCode());
    } else if (ParticipatorTypeEnum.TERMINAL.getKey().equals(loginUser.getUsertype())) {
      dto.setTerminalCode(loginUser.getConsumerCode());
    } else {
      return null;
    }
    //查询协议信息
    Page<Agreement> byConditions = agreementService.findByConditions(pageable, dto);
    if (Objects.isNull(byConditions)){
      return null;
    }
    ArrayList<AgreementReportVo> agreementReportVos = new ArrayList<>();
    List<Agreement> agreementList = byConditions.getRecords();
    if (!CollectionUtils.isEmpty(agreementList)) {
      //查询收益情况
      List<String> templateCodes = agreementList.stream().map(Agreement::getTemplateCode).collect(Collectors.toList());
      List<RewardRelAgreementVo> rewardRelAgreementVos = rewardRelAgreementVoService.findByParticipatorCodeAndTemplateCodes(loginUser.getConsumerCode(), templateCodes);
      //赋值
      agreementList.stream().forEach(agreement -> {
        AgreementReportVo agreementReportVo = nebulaToolkitService.copyObjectByWhiteList(agreement, AgreementReportVo.class, null, null);
        //设置模板信息值
        ProfitAgreementTemplate profitAgreementTemplate = agreement.getProfitAgreementTemplate();
        if (profitAgreementTemplate != null) {
          agreementReportVo.setEffectiveStartTime(profitAgreementTemplate.getEffectiveStartTime());
          agreementReportVo.setEffectiveEndTime(profitAgreementTemplate.getEffectiveEndTime());
          agreementReportVo.setSignStartTime(profitAgreementTemplate.getSignStartTime());
          agreementReportVo.setSignEndTime(profitAgreementTemplate.getSignEndTime());
          //设置政策
          Set<TemplatePolicyRelationship> templatePolicyRelationships = profitAgreementTemplate.getTemplatePolicyRelationships();
          if (!CollectionUtils.isEmpty(templatePolicyRelationships)) {
            List<String> collect = templatePolicyRelationships.stream().map(TemplatePolicyRelationship::getPolicyName).collect(Collectors.toList());
            agreementReportVo.setPolicyNames(collect);

          }
        }
        //设置当前参与者签署记录
        Set<AgreementSign> agreementSigns = agreement.getAgreementSigns();
        if (!CollectionUtils.isEmpty(agreementSigns)) {
          agreementSigns.stream().forEach(agreementSign -> {
            if (SignatoryEnum.TERMINAL.getDictCode().equals(agreementSign.getSignatory())) {
              agreementReportVo.setSignTime(agreementSign.getSignDate());
            }
          });
        }
        if(!CollectionUtils.isEmpty(rewardRelAgreementVos)){
          //设置收益收益情况
          List<RewardRelAgreementVo> collect = rewardRelAgreementVos.stream().filter(rewardRelAgreementVo -> agreementReportVo.getTemplateCode().equals(rewardRelAgreementVo.getTemplateCode())).collect(Collectors.toList());
          if (!CollectionUtils.isEmpty(collect)){
            agreementReportVo.setRewardStatisticsVos(new HashSet<RewardTypeStatisticsVo>(collect.get(0).getRewardTypeStatisticsVos()));
          }
        }
        agreementReportVos.add(agreementReportVo);
      });
    }
    Page<AgreementReportVo> agreementVoPage = new Page<>();
    agreementVoPage.setCurrent(byConditions.getCurrent());
    agreementVoPage.setSize(byConditions.getSize());
    agreementVoPage.setTotal(byConditions.getTotal());
    agreementVoPage.setRecords(agreementReportVos);
    return agreementVoPage;
  }
}
