package com.biz.crm.cps.mobile.terminal.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.mobile.terminal.dto.CashRecordReportDto;
import com.biz.crm.cps.mobile.terminal.repository.CashRecordReportVoRepository;
import com.biz.crm.cps.mobile.terminal.service.CashRecordReportVoService;
import com.biz.crm.cps.mobile.terminal.vo.CashRecordReportVo;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * @author hecheng
 * @description: 提现流水报表
 * @date 2021/10/11 下午4:51
 */
@Service
public class CashRecordReportVoServiceImpl implements CashRecordReportVoService {

  @Autowired
  private CashRecordReportVoRepository cashRecordReportVoRepository;

  @Override
  public Page<CashRecordReportVo> findTerminalByConditions(Pageable pageable, CashRecordReportDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (dto == null) {
      dto = new CashRecordReportDto();
    }
    return cashRecordReportVoRepository.findTerminalByConditions(pageable, dto);
  }

  @Override
  public Page<CashRecordReportVo> findDealerByConditions(Pageable pageable, CashRecordReportDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (dto == null) {
      dto = new CashRecordReportDto();
    }
    return cashRecordReportVoRepository.findDealerByConditions(pageable, dto);
  }

  @Override
  public Page<CashRecordReportVo> findConsumerByConditions(Pageable pageable, CashRecordReportDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (dto == null) {
      dto = new CashRecordReportDto();
    }
    return cashRecordReportVoRepository.findConsumerByConditions(pageable, dto);
  }

  @Override
  public Page<CashRecordReportVo> findUserGuideByConditions(Pageable pageable, CashRecordReportDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (dto == null) {
      dto = new CashRecordReportDto();
    }
    return cashRecordReportVoRepository.findUserGuideByConditions(pageable, dto);
  }
}
