package com.biz.crm.cps.mobile.terminal.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerCountDto;
import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.mobile.terminal.service.ConsumerIncreaseReportVoService;
import com.biz.crm.cps.mobile.terminal.vo.ConsumerIncreaseReportVo;
import com.biz.crm.mdm.business.user.sdk.enums.UserTypeEnum;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;

/**
 * 消费者新增情况报表Vo 服务接口实现
 * @Author dy
 * @DATE 2022/3/28
 **/
@Service("ConsumerIncreaseReportVoServiceImpl")
public class ConsumerIncreaseReportVoServiceImpl implements ConsumerIncreaseReportVoService {

  @Autowired
  private ConsumerVoService consumerVoService;
  @Autowired
  private LoginUserService loginUserService;

  @Override
  public ConsumerIncreaseReportVo findByCurrentUser() {

    ConsumerIncreaseReportVo consumerIncreaseReportVo = new ConsumerIncreaseReportVo();

    Date now = new Date();
    Date todayStart = DateUtils.truncate(now, Calendar.DATE);
    Date todayEnd = DateUtils.addMilliseconds(todayStart, (int) (DateUtils.MILLIS_PER_DAY - 1));
    Date yesterdayStart = DateUtils.addDays(todayStart, -1);
    Date yesterdayEnd = DateUtils.addMilliseconds(yesterdayStart, (int) (DateUtils.MILLIS_PER_DAY - 1));

    Calendar thisWeekStart = DateUtils.toCalendar(todayStart);
    thisWeekStart.set(Calendar.DAY_OF_WEEK,Calendar.MONDAY);
    Date thisWeekEnd = DateUtils.addMilliseconds(thisWeekStart.getTime(), (int) (7 * DateUtils.MILLIS_PER_DAY -1));

    LoginUserDetailsForCPS loginDetails = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    Validate.notNull(loginDetails,"获取当前登录用户信息失败");
    String usertype = loginDetails.getUsertype();
    String consumerCode = loginDetails.getConsumerCode();
    Integer total = 0;
    Integer todayIncrease = 0;
    Integer yesterdayIncrease = 0;
    Integer thisWeekIncrease = 0;

    ConsumerCountDto consumerCountDto = new ConsumerCountDto();
    // 如果当前登录用户是终端用户
    if(UserTypeEnum.TERMINAL.getCode().equals(usertype)){
      consumerCountDto.setTerminalCode(consumerCode);
      total = consumerVoService.countByConsumerCountDto(consumerCountDto);
      consumerCountDto.setConsumerRelevanceCreateStartDate(todayStart);
      consumerCountDto.setConsumerRelevanceCreateEndDate(todayEnd);
      todayIncrease = consumerVoService.countByConsumerCountDto(consumerCountDto);
      consumerCountDto.setConsumerRelevanceCreateStartDate(yesterdayStart);
      consumerCountDto.setConsumerRelevanceCreateEndDate(yesterdayEnd);
      yesterdayIncrease = consumerVoService.countByConsumerCountDto(consumerCountDto);
      consumerCountDto.setConsumerRelevanceCreateStartDate(thisWeekStart.getTime());
      consumerCountDto.setConsumerRelevanceCreateEndDate(thisWeekEnd);
      thisWeekIncrease = consumerVoService.countByConsumerCountDto(consumerCountDto);
    }
    // TODO 导购和消费者的关联
    consumerIncreaseReportVo.setTodayIncreaseCount(todayIncrease);
    consumerIncreaseReportVo.setYesterdayIncreaseCount(yesterdayIncrease);
    consumerIncreaseReportVo.setThisWeekIncreaseCount(thisWeekIncrease);
    consumerIncreaseReportVo.setTotalCount(total);
    return consumerIncreaseReportVo;
  }
}
