package com.biz.crm.cps.mobile.terminal.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.consumer.sdk.dto.ConsumerDto;
import com.biz.crm.cps.mobile.terminal.repository.ConsumerManageVoRepository;
import com.biz.crm.cps.mobile.terminal.service.ConsumerManageVoService;
import com.biz.crm.cps.mobile.terminal.vo.ConsumerManageVo;
import com.biz.crm.mdm.business.user.sdk.enums.UserTypeEnum;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 消费者信息vo服务实现
 * @Author dy
 * @DATE 2022/4/1
 **/
@Service("ConsumerManageVoServiceImpl")
public class ConsumerManageVoServiceImpl implements ConsumerManageVoService {

  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private ConsumerManageVoRepository consumerManageVoRepository;

  @Override
  public Page<ConsumerManageVo> findByConditions(Pageable pageable, ConsumerDto dto) {

    LoginUserDetailsForCPS loginDetails = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    Validate.notNull(loginDetails,"获取当前登录用户信息失败");
    String usertype = loginDetails.getUsertype();
    Page<ConsumerManageVo> result = new Page<>();
    // 如果是终端用户
    if(UserTypeEnum.TERMINAL.getCode().equals(usertype)){
      String consumerCode = loginDetails.getConsumerCode();
      dto.setTerminalCode(consumerCode);
      result = consumerManageVoRepository.findByConditions(pageable, dto);
    }
    // TODO 导购和消费者的关联
    return result;
  }
}
