package com.biz.crm.cps.mobile.terminal.service.internal;

import com.biz.crm.cps.business.reward.sdk.service.observer.RewardTypeStatisticsServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.biz.crm.cps.mobile.terminal.service.RewardTypeStatisticsVoService;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @author hecheng
 * @description: 奖励汇总报表
 * <pre>
 *   汇总各个具体奖励模块的奖励信息
 *   包含 奖励的名字，类型，标志、金额等
 * </pre>
 * @date 2021/8/24 下午6:47
 */
@Service
public class RewardTypeStatisticsVoServiceImpl implements RewardTypeStatisticsVoService {

  @Autowired(required = false)
  private List<RewardTypeStatisticsServiceObserver> rewardTypeStatisticsServiceObserverList;

  @Override
  public List<RewardTypeStatisticsVo> findByParticipatorCodeAndRecordCodes(String participatorCode, List<String> recordCodes) {
    if (Objects.isNull(participatorCode) || CollectionUtils.isEmpty(recordCodes) || CollectionUtils.isEmpty(rewardTypeStatisticsServiceObserverList)) {
      return null;
    }
    List<RewardTypeStatisticsVo> list = Lists.newArrayList();
    for (RewardTypeStatisticsServiceObserver rewardServiceObserver : rewardTypeStatisticsServiceObserverList) {
      RewardTypeStatisticsVo vo = rewardServiceObserver.onRequestRewardTypeStatisticsVo(participatorCode, recordCodes);
      if (Objects.nonNull(vo)) {
        list.add(vo);
      }
    }
    return list;
  }

  @Override
  public List<RewardTypeStatisticsVo> findByTenantCodeAndTriggerAction(String tenantCode, String triggerAction) {
    if (StringUtils.isBlank(tenantCode) || StringUtils.isBlank(triggerAction) || CollectionUtils.isEmpty(rewardTypeStatisticsServiceObserverList)) {
      return null;
    }
    List<RewardTypeStatisticsVo> list = Lists.newArrayList();
    for (RewardTypeStatisticsServiceObserver rewardServiceObserver : rewardTypeStatisticsServiceObserverList) {
      RewardTypeStatisticsVo vo = rewardServiceObserver.onRequestRewardTypeStatisticsVo(tenantCode, triggerAction);
      if (Objects.nonNull(vo)) {
        list.add(vo);
      }
    }
    return null;
  }
}
