package com.biz.crm.cps.mobile.terminal.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum;
import com.biz.crm.cps.mobile.terminal.dto.ScanCodeRecordReportDto;
import com.biz.crm.cps.mobile.terminal.repository.ScanCodeRecordReportVoRepository;
import com.biz.crm.cps.mobile.terminal.service.ScanCodeMaterialVoService;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeMaterialVo;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordReportVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 扫码记录报表service实现类
 *
 * @author songjingen
 */
@Service
public class ScanCodeMaterialVoServiceImpl implements ScanCodeMaterialVoService {

  @Autowired
  private ScanCodeRecordReportVoRepository scanCodeRecordReportVoRepository;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  /**
   * 通过扫码编码集合查询扫码产品信息
   * @param recordCodes
   * @return
   */
  @Override
  public List<ScanCodeMaterialVo> findByRecordCodes(List<String> recordCodes) {
    if (CollectionUtils.isEmpty(recordCodes)) {
      return null;
    }
    ScanCodeRecordReportDto dto = new ScanCodeRecordReportDto();
    dto.setRecordCodes(recordCodes);
    dto.setScanParticipatorCode(loginUserService.getLoginDetails(LoginUserDetailsForCPS.class).getConsumerCode());
    List<ScanCodeRecordReportVo> list = this.scanCodeRecordReportVoRepository.findByConditions(dto);
    if (CollectionUtils.isEmpty(list)) {
      return null;
    }
    //将数据用产品编码分组
    Map<String, List<ScanCodeRecordReportVo>> listMapByproductCode = list.stream().collect(Collectors.groupingBy(ScanCodeRecordReportVo::getProductCode));
    //分组后的数据组装成新的集合
    ArrayList<ScanCodeMaterialVo> vos = new ArrayList<>();
    for(Map.Entry<String, List<ScanCodeRecordReportVo>> entry : listMapByproductCode.entrySet()){
      List<ScanCodeRecordReportVo> scanCodeRecordReportVos = entry.getValue();
      String productCode = entry.getKey();
      if (CollectionUtils.isEmpty(scanCodeRecordReportVos)) {
        continue;
      }
      String materialName = "";
      BigDecimal boxCount = BigDecimal.ZERO;
      BigDecimal bottleCount = BigDecimal.ZERO;
      List<String> boxBarCodes = new ArrayList<>();
      List<String> bottleBarCodes = new ArrayList<>();
      for (ScanCodeRecordReportVo vo : scanCodeRecordReportVos) {
        if (BarCodeTypeEnum.BOX.getFlag().equals(vo.getBarCodeType())) {
          boxCount = boxCount.add(BigDecimal.ONE);
          boxBarCodes.add(vo.getBarCode());
        } else if (BarCodeTypeEnum.BOTTLE.getFlag().equals(vo.getBarCodeType())) {
          bottleCount = bottleCount.add(BigDecimal.ONE);
          bottleBarCodes.add(vo.getBarCode());
        }
        materialName = vo.getMaterialName();
      }
      ScanCodeMaterialVo vo = new ScanCodeMaterialVo();
      vo.setProductCode(productCode);
      vo.setMaterialName(materialName);
      vo.setBoxCount(boxCount);
      vo.setBottleCount(bottleCount);
      vo.setBoxBarCodes(boxBarCodes);
      vo.setBottleBarCodes(bottleBarCodes);
      vos.add(vo);
    }
    return vos;
  }

}
