package com.biz.crm.cps.mobile.terminal.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.mobile.terminal.dto.ScanCodeRecordReportAllPaginationDto;
import com.biz.crm.cps.mobile.terminal.dto.ScanCodeRecordReportGuidePaginationDto;
import com.biz.crm.cps.mobile.terminal.repository.ScanCodeRecordReportAllVoRepository;
import com.biz.crm.cps.mobile.terminal.service.ScanCodeRecordReportAllVoService;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordReportAllVo;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordReportGuideVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;

/**
 * 扫码记录报表接口实现
 *
 * @author sunx
 * @date 2022/3/29
 */
@Service
@Slf4j
public class ScanCodeRecordReportAllVoServiceImpl implements ScanCodeRecordReportAllVoService {

  @Autowired
  private ScanCodeRecordReportAllVoRepository scanCodeRecordReportAllVoRepository;
  @Autowired
  private LoginUserService loginUserService;

  @Override
  public Page<ScanCodeRecordReportGuideVo> findUserGuideByConditions(
      Pageable pageable, ScanCodeRecordReportGuidePaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new ScanCodeRecordReportGuidePaginationDto());
    dto.setParticipatorType(ParticipatorTypeEnum.USER_GUIDE.getKey());
    Page<ScanCodeRecordReportGuideVo> page =
        this.scanCodeRecordReportAllVoRepository.findUserGuideByConditions(pageable, dto);
    if (Objects.nonNull(page) && !CollectionUtils.isEmpty(page.getRecords())) {
      for (ScanCodeRecordReportGuideVo item : page.getRecords()) {
        item.setRemark(Optional.ofNullable(item.getRemark()).orElse(StringUtils.EMPTY));
      }
    }
    return page;
  }

  @Override
  public Page<ScanCodeRecordReportAllVo> findByConditions(Pageable pageable, ScanCodeRecordReportAllPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new ScanCodeRecordReportAllPaginationDto());
    LoginUserDetailsForCPS loginDetails = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    Validate.notNull(loginDetails,"获取当前登录用户信息失败");
    dto.setParticipatorType(loginDetails.getUsertype());
    dto.setScanParticipatorCode(loginDetails.getConsumerCode());
    if (dto.getCreateTime() != null) {
      Date start = DateUtils.addMonths(DateUtils.ceiling(dto.getCreateTime(), Calendar.MONTH), -1);
      Date end = DateUtils.addSeconds(DateUtils.ceiling(dto.getCreateTime(), Calendar.MONTH), -1);
      dto.setCreateStartTime(start);
      dto.setCreateEndTime(end);
    }
    Page<ScanCodeRecordReportAllVo> page = this.scanCodeRecordReportAllVoRepository.findByConditions(pageable, dto);
    if (Objects.nonNull(page) && !CollectionUtils.isEmpty(page.getRecords())) {
      for (ScanCodeRecordReportAllVo item : page.getRecords()) {
        item.setRemark(Optional.ofNullable(item.getRemark()).orElse(StringUtils.EMPTY));
      }
    }
    return page;
  }
}
