package com.biz.crm.cps.mobile.terminal.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayPolicyRangeVo;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayPolicyVo;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.constant.QuantifyConstant;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.dto.QuantifyPolicyDto;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.vo.QuantifyPolicyVo;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.vo.QuantifyRangeVo;
import com.biz.crm.cps.business.agreement.local.entity.TemplatePolicyRelationship;
import com.biz.crm.cps.business.agreement.local.repository.TemplatePolicyRelationshipRepository;
import com.biz.crm.cps.business.agreement.sdk.common.constant.AgreementCodeConstant;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementLadderVoService;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyServiceObserver;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementLadderVo;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementPolicyVo;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyConfiguration;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyPolicy;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.service.QuantifyPolicyService;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.utils.QuantifyUtils;
import com.biz.crm.cps.business.policy.scan.sdk.vo.ScanCodePolicyVo;
import com.biz.crm.cps.business.policy.scan.sdk.vo.ScanCodeRangeVo;
import com.biz.crm.cps.business.product.sdk.common.constant.MaterialDimensionConstant;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.business.product.sdk.vo.MaterialVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelScanCodeItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelScanCodeVo;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordPageDto;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.biz.crm.cps.mobile.terminal.dto.ScanCodeRecordReportDto;
import com.biz.crm.cps.mobile.terminal.repository.ScanCodeRecordRelateActivityVoRepository;
import com.biz.crm.cps.mobile.terminal.repository.ScanCodeRecordReportVoRepository;
import com.biz.crm.cps.mobile.terminal.service.RewardRelScanCodeVoService;
import com.biz.crm.cps.mobile.terminal.service.ScanCodeRecordReportVoService;
import com.biz.crm.cps.mobile.terminal.vo.AgreementDetailsVo;
import com.biz.crm.cps.mobile.terminal.vo.PolicyDetailsVo;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeReachVo;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordReportVo;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeStatisticsVo;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 扫码记录报表service实现类
 *
 * @author songjingen
 */
@Service
public class ScanCodeRecordReportVoServiceImpl implements ScanCodeRecordReportVoService {

  @Autowired
  private ScanCodeRecordReportVoRepository scanCodeRecordReportVoRepository;

  @Autowired private ScanCodeRecordRelateActivityVoRepository scanCodeRecordRelateActivityVoRepository;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Autowired
  private MaterialVoService materialVoService;

  @Autowired
  private RewardRelScanCodeVoService rewardRelScanCodeVoService;

  @Autowired
  private AgreementVoService agreementVoService;

  @Autowired
  private QuantifyPolicyService quantifyPolicyService;

  @Autowired
  private ScanCodeRecordVoService scanCodeRecordVoService;

  @Autowired
  private AgreementLadderVoService agreementLadderVoService;

  @Autowired
  private TemplatePolicyRelationshipRepository templatePolicyRelationshipRepository;

  @Autowired
  private List<AgreementPolicyServiceObserver> agreementPolicyServiceObservers;

  /**
   * 通过查询条件查询当前参与者的扫码记录分页信息
   *
   * @param pageable
   * @param dto
   * @return
   */
  @Override
  public ScanCodeStatisticsVo findByConditions(Pageable pageable, ScanCodeRecordReportDto dto) {
    /**
     * 1、查询报表数据
     * 2、查询物料数据并转成map
     * 3、查询分利信息并转成map
     * 4、赋值
     */
    ScanCodeStatisticsVo scanCodeStatisticsVo = new ScanCodeStatisticsVo();
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (dto == null) {
      dto = new ScanCodeRecordReportDto();
    }
    // 1、======
    LoginUserDetailsForCPS loginUser = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    dto.setScanParticipatorCode(loginUser.getConsumerCode());
    dto.setParticipatorType(loginUser.getUsertype());
    if (dto.getCreateTime() != null) {
      Date start = DateUtils.addMonths(DateUtils.ceiling(dto.getCreateTime(), Calendar.MONTH), -1);
      Date end = DateUtils.addSeconds(DateUtils.ceiling(dto.getCreateTime(), Calendar.MONTH), -1);
      dto.setCreateTimeStart(start);
      dto.setCreateTimeEnd(end);
    }
    Page<ScanCodeRecordReportVo> page = scanCodeRecordReportVoRepository.findByConditions(pageable, dto);
    if (Objects.isNull(page)) {
      return null;
    }
    //获取用户的协议信息
    List<AgreementDetailsVo> agreementDetailsVos = this.getUserAgreement(dto);
    List<ScanCodeRecordReportVo> records = page.getRecords();
    if (!CollectionUtils.isEmpty(records)) {
      // 2、======
      Map<String, String> materialVoMap = this.findMaterialVoMapByRecords(records);
      // 3、======
      Map<String, List<RewardRelScanCodeItemVo>> rewardVoMap = this.findRewardVoMapByRecords(records, loginUser);
      //4、======
      records.stream().forEach(s -> {
        s.setMaterialName(materialVoMap.get(s.getProductCode()));
        s.setRewardRelScanCodeItemVos(rewardVoMap.get(s.getRecordCode()));
        this.setAgreementInfo(s, agreementDetailsVos);
        if (StringUtils.isBlank(s.getScanCodeWarning())) {
          scanCodeStatisticsVo.setQualifiedBottleNumber(scanCodeStatisticsVo.getQualifiedBottleNumber().add(Optional.ofNullable(s.getStandardUnitBottleValue()).orElse(BigDecimal.ZERO)));
          scanCodeStatisticsVo.setQualifiedBoxNumber(scanCodeStatisticsVo.getQualifiedBoxNumber().add(Optional.ofNullable(s.getStandardUnitBoxValue()).orElse(BigDecimal.ZERO)));
        } else {
          scanCodeStatisticsVo.setUnqualifiedBottleNumber(scanCodeStatisticsVo.getUnqualifiedBottleNumber().add(Optional.ofNullable(s.getStandardUnitBottleValue()).orElse(BigDecimal.ZERO)));
          scanCodeStatisticsVo.setUnqualifiedBoxNumber(scanCodeStatisticsVo.getUnqualifiedBoxNumber().add(Optional.ofNullable(s.getStandardUnitBoxValue()).orElse(BigDecimal.ZERO)));
        }
        scanCodeStatisticsVo.setAllBottleNumber(scanCodeStatisticsVo.getAllBottleNumber().add(Optional.ofNullable(s.getStandardUnitBottleValue()).orElse(BigDecimal.ZERO)));
        scanCodeStatisticsVo.setAllBoxNumber(scanCodeStatisticsVo.getAllBoxNumber().add(Optional.ofNullable(s.getStandardUnitBoxValue()).orElse(BigDecimal.ZERO)));
      });
      scanCodeStatisticsVo.setRecordReportVoPage(page);
    }
    return scanCodeStatisticsVo;
  }

  /**
   * 查询的物料信息转成map
   *
   * @return
   */
  private Map<String, String> findMaterialVoMapByRecords(List<ScanCodeRecordReportVo> records) {
    List<String> productCodes = records.stream().map(ScanCodeRecordReportVo::getProductCode).collect(Collectors.toList());
    List<MaterialVo> materialVos = materialVoService.findByMaterialCode(productCodes);
    if (CollectionUtils.isEmpty(materialVos)) {
      return new HashMap<>();
    }
    Map<String, String> materialVoMap = materialVos.stream().collect(Collectors.toMap(MaterialVo::getMaterialCode, MaterialVo::getMaterialName));
    return materialVoMap;
  }

  /**
   * 查询的分利信息转成map
   *
   * @return
   */
  private Map<String, List<RewardRelScanCodeItemVo>> findRewardVoMapByRecords(List<ScanCodeRecordReportVo> records, LoginUserDetailsForCPS loginUser) {
    List<String> recodeCodes = records.stream().map(ScanCodeRecordReportVo::getRecordCode).collect(Collectors.toList());
    String dictCode = ParticipatorTypeEnum.getByKey(loginUser.getUsertype()).getDictCode();
    List<RewardRelScanCodeVo> rewardRelScanCodeVos = rewardRelScanCodeVoService.findByParticipatorCodeAndRecordCodes(loginUser.getConsumerCode(), dictCode, recodeCodes);
    if (CollectionUtils.isEmpty(rewardRelScanCodeVos)) {
      return new HashMap<>();
    }
    Map<String, List<RewardRelScanCodeItemVo>> rewardVoMap = rewardRelScanCodeVos.stream().collect(Collectors.toMap(RewardRelScanCodeVo::getRecordCode, RewardRelScanCodeVo::getRewardRelScanCodeItemVos));
    return rewardVoMap;
  }

  @Override
  public List<ScanCodeReachVo> findScanTargetAndReach(String dateType) {
    /**
     * step1:获取协议列表
     * step2:根据协议列表获取模板列表
     * step3:计算销量目标
     * step4:获取扫码数量
     * step5:计算任务达成率
     */
    List<ScanCodeReachVo> list = new ArrayList<>();
    String terminalCode = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class).getConsumerCode();
    if (StringUtils.isAnyBlank(terminalCode, dateType)) {
      return null;
    }
    BigDecimal salesTarget = BigDecimal.ZERO;
    //查询终端进行中的协议列表
    LoginUserAgreementDto loginUserAgreementDto = new LoginUserAgreementDto();
    loginUserAgreementDto.setTerminalCode(terminalCode);
    loginUserAgreementDto.setAgreementStatus(AgreementStatusEnum.EXECUTING.getCode());
    loginUserAgreementDto.setSignStatus(SignStatusEnum.SIGNED.getCode());
    List<AgreementVo> agreementVos = agreementVoService.findByConditions(loginUserAgreementDto);
    //只需要包量任务的
    List<String> templateCodes = new ArrayList<>();
    Map<String, AgreementVo> agreementMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(agreementVos)) {
      for (AgreementVo item : agreementVos) {
        templateCodes.add(item.getTemplateCode());
        agreementMap.put(item.getTemplateCode(), item);
      }
      List<TemplatePolicyRelationship> relationships = templatePolicyRelationshipRepository.findByPolicyCodeAndTemplateCodes("quantifyPolicy", templateCodes);
      List<AgreementVo> result = new ArrayList<>();
      if (!CollectionUtils.isEmpty(relationships)) {
        for (TemplatePolicyRelationship relationship : relationships) {
          result.add(agreementMap.get(relationship.getTemplateCode()));
        }
      }
      for (AgreementVo item : result) {
        //根据协议查询政策模板
        QuantifyPolicyDto quantifyPolicyDto = new QuantifyPolicyDto();
        quantifyPolicyDto.setTemplateCodes(Arrays.asList(item.getTemplateCode()));
        List<QuantifyPolicy> quantifyPolicies = quantifyPolicyService.findByConditions(quantifyPolicyDto);
        //循环政策模板获取本月销量目标
        Calendar calendar = Calendar.getInstance();
        int nowMonth = calendar.get(Calendar.MONTH) + 1;
        for (QuantifyPolicy policy : quantifyPolicies) {
          for (QuantifyConfiguration configuration : policy.getQuantifyConfigurations()) {
            AgreementLadderVo agreementLadderVo = agreementLadderVoService.findByLadderCode(configuration.getAgreementLadderCode());
            if (Objects.isNull(agreementLadderVo)) {
              continue;
            }
            //根据查询类型不同累计不同的销量目标
            if (dateType.equals(QuantifyConstant.MONTH)) {
              salesTarget = salesTarget.add(QuantifyUtils.getScaleByMonth(nowMonth, agreementLadderVo));
            } else {
              salesTarget = salesTarget.add(agreementLadderVo.getYearSaleNum());
            }
          }
        }
        //查询本月已扫码数量
        ScanCodeRecordPageDto scanCodeRecordPageDto = new ScanCodeRecordPageDto();
        //根据时间类型构造不同的查询起始时间
        if (dateType.equals(QuantifyConstant.MONTH)) {
          scanCodeRecordPageDto.setCreateTimeStart(DateUtils.addMonths(DateUtils.ceiling(new Date(), Calendar.MONTH), -1));
        } else {
          scanCodeRecordPageDto.setCreateTimeStart(DateUtils.addYears(DateUtils.ceiling(new Date(), Calendar.YEAR), -1));
        }
        scanCodeRecordPageDto.setScanCodeException(ScanCodeExceptionEnum.NO.getCode());
        scanCodeRecordPageDto.setScanParticipatorCode(terminalCode);
        BigDecimal scanNumber = scanCodeRecordVoService.countSalesByScanCodeRecordPageDto(scanCodeRecordPageDto);
        //计算达成率
        BigDecimal reachRate = BigDecimal.ZERO;
        if (salesTarget.compareTo(BigDecimal.ZERO) == 0) {
          reachRate = new BigDecimal(100);
        } else {
          reachRate = scanNumber.divide(salesTarget, 2, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        }
        //构造达成率返回
        ScanCodeReachVo scanCodeReachVo = new ScanCodeReachVo();
        scanCodeReachVo.setSalesTarget(salesTarget);
        scanCodeReachVo.setScanNumber(scanNumber);
        scanCodeReachVo.setReachRate(reachRate);
        scanCodeReachVo.setAgreeName(item.getBelongTemplate());
        list.add(scanCodeReachVo);
      }
    }
    return list;
  }

  /**
   * 获取经销商/终端的协议-政策关联
   */
  private List<AgreementDetailsVo> getUserAgreement(ScanCodeRecordReportDto dto) {
    LoginUserAgreementDto loginUserAgreementDto = new LoginUserAgreementDto();
    LoginUserDetailsForCPS loginUserDetailsForCPS = this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    //根据入参的参与者类型设置不同的参数
    if (ParticipatorTypeEnum.DEALER.getKey().equals(dto.getParticipatorType())) {
      loginUserAgreementDto.setCustomerCode(loginUserDetailsForCPS.getConsumerCode());
    } else {
      loginUserAgreementDto.setTerminalCode(loginUserDetailsForCPS.getConsumerCode());
    }
    loginUserAgreementDto.setAgreementStatus(AgreementStatusEnum.EXECUTING.getCode());
    loginUserAgreementDto.setSignStatus(SignStatusEnum.SIGNED.getCode());
    List<AgreementVo> agreementVos = agreementVoService.findByConditions(loginUserAgreementDto);
    if (CollectionUtils.isEmpty(agreementVos)) {
      return null;
    }
    List<AgreementDetailsVo> agreementDetailsVos = Lists.newArrayList();
    //循环协议，获取协议对应的政策列表
    if (CollectionUtils.isEmpty(this.agreementPolicyServiceObservers)) {
      return null;
    }
    for (AgreementVo agreementVo : agreementVos) {
      AgreementDetailsVo agreementDetailsVo = new AgreementDetailsVo();
      agreementDetailsVo.setAgreementCode(agreementVo.getAgreementCode());
      agreementDetailsVo.setAgreementName(agreementVo.getAgreementName());
      //循环政策监听，获取协议下的政策数据并解析为vo
      for (AgreementPolicyServiceObserver observer : agreementPolicyServiceObservers) {
        AgreementPolicyVo policyVo = observer.onFindDetailsByTemplateCode(agreementVo.getTemplateCode());
        if (ObjectUtils.isNotEmpty(policyVo)) {
          convertPolicyVo(policyVo, agreementDetailsVo);
        }
      }
      agreementDetailsVos.add(agreementDetailsVo);
    }
    return agreementDetailsVos;
  }

  /**
   * 转换政策vo
   *
   * @param policyVo           政策vo
   * @param agreementDetailsVo 协议详情vo
   */
  private void convertPolicyVo(AgreementPolicyVo policyVo, AgreementDetailsVo agreementDetailsVo) {
    List<PolicyDetailsVo> detailsVos = agreementDetailsVo.getPolicyDetailsVos();
    if (CollectionUtils.isEmpty(detailsVos)) {
      detailsVos = Lists.newArrayList();
    }
    PolicyDetailsVo policyDetailsVo = new PolicyDetailsVo();
    policyDetailsVo.setPolicyCode(policyVo.getPolicyKey());
    //解析分利政策
    if (policyVo instanceof QuantifyPolicyVo) {
      //包量政策数据解析
      QuantifyPolicyVo quantifyPolicyVo = (QuantifyPolicyVo) policyVo;
      policyDetailsVo.setPolicyName(AgreementCodeConstant.AGREEMENT_POLICY_QUANTIFY_NAME);
      policyDetailsVo.setDimensionFlag(quantifyPolicyVo.getDimensionFlag());
      if (!MaterialDimensionConstant.DIMENSION_ALL.equals(quantifyPolicyVo.getDimensionFlag())) {
        policyDetailsVo.setProductCodes(this.getQuantifyPolicyRange(quantifyPolicyVo));
      }
    } else if (policyVo instanceof DisplayPolicyVo) {
      //陈列政策数据解析
      DisplayPolicyVo displayPolicyVo = (DisplayPolicyVo) policyVo;
      policyDetailsVo.setPolicyName(AgreementCodeConstant.AGREEMENT_POLICY_DISPLAY_NAME);
      policyDetailsVo.setDimensionFlag(displayPolicyVo.getDimensionFlag());
      if (!MaterialDimensionConstant.DIMENSION_ALL.equals(displayPolicyVo.getDimensionFlag())) {
        policyDetailsVo.setProductCodes(this.getDisplayPolicyRange(displayPolicyVo));
      }
    } else {
      //扫码数据解析
      ScanCodePolicyVo scanCodePolicyVo = (ScanCodePolicyVo) policyVo;
      policyDetailsVo.setPolicyName(AgreementCodeConstant.AGREEMENT_POLICY_SCAN_NAME);
      policyDetailsVo.setDimensionFlag(scanCodePolicyVo.getScanCodeConfigurationVos().stream().findAny().get().getDimensionFlag());
      if (!MaterialDimensionConstant.DIMENSION_ALL.equals(policyDetailsVo.getDimensionFlag())) {
        policyDetailsVo.setProductCodes(this.getScanCodePolicyRange(scanCodePolicyVo));
      }
    }
    detailsVos.add(policyDetailsVo);
    agreementDetailsVo.setPolicyDetailsVos(detailsVos);
  }

  /**
   * 获取政策配置的物料编码列表
   * 返回政策下所有配置的物料编码集合
   *
   * @param quantifyPolicy 包量政策
   */
  private List<String> getQuantifyPolicyRange(QuantifyPolicyVo quantifyPolicy) {
    List<String> materialCodes = Lists.newArrayList();
    quantifyPolicy.getQuantifyConfigurations().forEach(configuration -> {
      List<String> materialCodeList = this.materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(configuration.getQuantifyRanges().stream().map(QuantifyRangeVo::getSpecialCode).collect(Collectors.toList()), quantifyPolicy.getDimensionFlag());
      if (!CollectionUtils.isEmpty(materialCodeList)) {
        materialCodes.addAll(materialCodeList);
      }
    });
    return materialCodes;
  }

  /**
   * 获取政策配置的物料编码列表
   * 返回政策下所有配置的物料编码集合
   *
   * @param displayPolicyVo 陈列政策
   */
  private List<String> getDisplayPolicyRange(DisplayPolicyVo displayPolicyVo) {
    List<String> materialCodes = Lists.newArrayList();
    displayPolicyVo.getDisplayPolicyConfigurations().forEach(configuration -> {
      List<String> materialCodeList = this.materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(configuration.getDisplayPolicyRanges().stream().map(DisplayPolicyRangeVo::getSpecialCode).collect(Collectors.toList()), displayPolicyVo.getDimensionFlag());
      if (!CollectionUtils.isEmpty(materialCodeList)) {
        materialCodes.addAll(materialCodeList);
      }
    });
    return materialCodes;
  }

  /**
   * 获取政策配置的物料编码列表
   * 返回政策下所有配置的物料编码集合
   *
   * @param scanCodePolicyVo 扫码政策
   */
  private List<String> getScanCodePolicyRange(ScanCodePolicyVo scanCodePolicyVo) {
    List<String> materialCodes = Lists.newArrayList();
    scanCodePolicyVo.getScanCodeConfigurationVos().forEach(configuration -> {
      List<String> materialCodeList = this.materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(configuration.getScanCodeRanges().stream().map(ScanCodeRangeVo::getSpecialCode).collect(Collectors.toList()), configuration.getDimensionFlag());
      if (!CollectionUtils.isEmpty(materialCodeList)) {
        materialCodes.addAll(materialCodeList);
      }
    });
    return materialCodes;
  }

  /**
   * 设置扫码记录的协议相关数据
   *
   * @param scanCodeRecordReportVo 扫码记录
   * @param agreementDetailsVos    用户管理的协议列表
   */
  private void setAgreementInfo(ScanCodeRecordReportVo scanCodeRecordReportVo, List<AgreementDetailsVo> agreementDetailsVos) {
    if (CollectionUtils.isEmpty(agreementDetailsVos)) {
      return;
    }
    StringBuilder agreementBuilder = new StringBuilder();
    Set<String> policyBuilder = new HashSet<>();
    agreementDetailsVos.forEach(detail -> {
      if (!CollectionUtils.isEmpty(detail.getPolicyDetailsVos())) {
        Set<String> policyNames = new HashSet<>();
        detail.getPolicyDetailsVos().forEach(policy -> {
          if (MaterialDimensionConstant.DIMENSION_ALL.equals(policy.getDimensionFlag())) {
            policyNames.add(policy.getPolicyName());
          } else if (!CollectionUtils.isEmpty(policy.getProductCodes())) {
            if (policy.getProductCodes().contains(scanCodeRecordReportVo.getProductCode())) {
              policyNames.add(policy.getPolicyName());
            }
          }
        });
        if (!CollectionUtils.isEmpty(policyNames)) {
          agreementBuilder.append(",").append(detail.getAgreementName());
          policyBuilder.addAll(policyNames);
        }
      }
    });
    if (ObjectUtils.isNotEmpty(agreementBuilder)) {
      scanCodeRecordReportVo.setAgreementName(agreementBuilder.substring(1).toString());
    }
    if (!CollectionUtils.isEmpty(policyBuilder)) {
      StringBuilder policy = new StringBuilder();
      policyBuilder.forEach(policyName -> {
        policy.append(",").append(policyName);
      });
      scanCodeRecordReportVo.setPolicyName(policy.substring(1).toString());
    }

  }

}
