package com.biz.crm.cps.mobile.terminal.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.mobile.terminal.dto.ScanCodeRecordReportAllPaginationDto;
import com.biz.crm.cps.mobile.terminal.repository.ScanCodeRecordReportAllVoRepository;
import com.biz.crm.cps.mobile.terminal.service.ScanCodeRecordStatisticalVoService;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordReportAllVo;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordStatisticalVo;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;

/**
 * 扫码记录统计Service实现
 * @Author dy
 * @DATE 2022/4/15
 **/
@Service("ScanCodeRecordStatisticalVoServiceImpl")
public class ScanCodeRecordStatisticalVoServiceImpl implements ScanCodeRecordStatisticalVoService {

  @Autowired
  private ScanCodeRecordReportAllVoRepository scanCodeRecordReportAllVoRepository;
  @Autowired
  private LoginUserService loginUserService;

  @Override
  public ScanCodeRecordStatisticalVo findByCurrentUser(String scanType) {

    ScanCodeRecordReportAllPaginationDto dto = new ScanCodeRecordReportAllPaginationDto();
    LoginUserDetailsForCPS loginDetails = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    Validate.notNull(loginDetails, "获取当前登录用户信息失败");
    dto.setParticipatorType(loginDetails.getUsertype());
    dto.setScanParticipatorCode(loginDetails.getConsumerCode());
    dto.setScanType(scanType);

    ScanCodeRecordStatisticalVo scanCodeRecordStatisticalVo = new ScanCodeRecordStatisticalVo();
    List<ScanCodeRecordReportAllVo> records = this.scanCodeRecordReportAllVoRepository.findByConditions(dto);
    if (CollectionUtils.isEmpty(records)) {
      return scanCodeRecordStatisticalVo;
    }
    records.stream().filter(s-> ScanCodeExceptionEnum.NO.getCode().equals(s.getScanCodeException())).forEach(s -> {
      if (StringUtils.isBlank(s.getScanCodeWarning())) {
        scanCodeRecordStatisticalVo.setQualifiedBottleNumber(scanCodeRecordStatisticalVo.getQualifiedBottleNumber().add(Optional.ofNullable(s.getStandardUnitBottleValue()).orElse(BigDecimal.ZERO)));
        scanCodeRecordStatisticalVo.setQualifiedBoxNumber(scanCodeRecordStatisticalVo.getQualifiedBoxNumber().add(Optional.ofNullable(s.getStandardUnitBoxValue()).orElse(BigDecimal.ZERO)));
      } else {
        scanCodeRecordStatisticalVo.setUnqualifiedBottleNumber(scanCodeRecordStatisticalVo.getUnqualifiedBottleNumber().add(Optional.ofNullable(s.getStandardUnitBottleValue()).orElse(BigDecimal.ZERO)));
        scanCodeRecordStatisticalVo.setUnqualifiedBoxNumber(scanCodeRecordStatisticalVo.getUnqualifiedBoxNumber().add(Optional.ofNullable(s.getStandardUnitBoxValue()).orElse(BigDecimal.ZERO)));
      }
      scanCodeRecordStatisticalVo.setAllBottleNumber(scanCodeRecordStatisticalVo.getAllBottleNumber().add(Optional.ofNullable(s.getStandardUnitBottleValue()).orElse(BigDecimal.ZERO)));
      scanCodeRecordStatisticalVo.setAllBoxNumber(scanCodeRecordStatisticalVo.getAllBoxNumber().add(Optional.ofNullable(s.getStandardUnitBoxValue()).orElse(BigDecimal.ZERO)));
    });
    return scanCodeRecordStatisticalVo;
  }
}
