package com.biz.crm.cps.mobile.terminal.service.internal;

import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeRecordVo;
import com.biz.crm.cps.mobile.terminal.service.ScanCodeRecordWarningReportVoService;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordWarningReportVo;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * 扫码记录预警报表Service实现
 * @Author dy
 * @DATE 2022/4/12
 **/
@Service("ScanCodeRecordWarningReportVoServiceImpl")
public class ScanCodeRecordWarningReportVoServiceImpl implements ScanCodeRecordWarningReportVoService {

  @Autowired
  private ScanCodeRecordVoService scanCodeRecordVoService;

  @Override
  public List<ScanCodeRecordWarningReportVo> findByRecordCode(String recordCode) {
    if(StringUtils.isBlank(recordCode)){
      return null;
    }
    ScanCodeRecordVo scanCodeRecordVo = scanCodeRecordVoService.findByRecordCode(recordCode);
    if(Objects.isNull(scanCodeRecordVo) || StringUtils.isBlank(scanCodeRecordVo.getScanCodeWarning())
        || ScanCodeExceptionEnum.NO.getCode().equals(scanCodeRecordVo.getScanCodeWarning())){
      return null;
    }
    String scanCodeWarning = scanCodeRecordVo.getScanCodeWarning();
    String[] warningCodes = StringUtils.split(scanCodeWarning, "\\,");
    if(warningCodes.length == 0){
      return null;
    }
    List<ScanCodeRecordWarningReportVo> scanCodeRecordWarningVoList = Lists.newArrayList();
    for (String warningCode : warningCodes) {
      ScanCodeExceptionEnum scanCodeExceptionEnum = ScanCodeExceptionEnum.findByCode(warningCode);
      if(scanCodeExceptionEnum == null){
        continue;
      }
      ScanCodeRecordWarningReportVo scanCodeRecordWarningReportVo = new ScanCodeRecordWarningReportVo();
      scanCodeRecordWarningReportVo.setScanCodeWarning(scanCodeExceptionEnum.getType());
      scanCodeRecordWarningReportVo.setScanCodeWarningDesc(scanCodeExceptionEnum.getDes());
      scanCodeRecordWarningVoList.add(scanCodeRecordWarningReportVo);
    }
    return scanCodeRecordWarningVoList;
  }
}
