package com.biz.crm.cps.mobile.terminal.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.constant.QuantifyConstant;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanTypeEnum;
import com.biz.crm.cps.mobile.terminal.dto.ScanCodeRecordReportDto;
import com.biz.crm.cps.mobile.terminal.repository.ScanCodeRecordReportVoRepository;
import com.biz.crm.cps.mobile.terminal.service.ScanCodeStandardVoService;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordReportVo;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeStandardVo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * 统计条码标准转换相关service实现类
 *
 * @author songjingen
 */
@Service
public class ScanCodeStandardVoServiceImpl implements ScanCodeStandardVoService {

  @Autowired
  private ScanCodeRecordReportVoRepository scanCodeRecordReportVoRepository;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  /**
   * 查询经销商月度和年度的标瓶和标箱
   *
   * @param dateType
   * @return
   */
  @Override
  public ScanCodeStandardVo findScanCodeStandardVoByDateType(String dateType) {
    /**
     * 1、根据时间类型构造不同的查询起始时间
     * 2、查询扫码记录
     * 3、计算标箱和标瓶数据
     */
    ScanCodeStandardVo scanCodeStandardVo = new ScanCodeStandardVo();
    LoginUserDetailsForCPS loginUser = this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    if (loginUser == null || StringUtils.isBlank(dateType)) {
      return scanCodeStandardVo;
    }
    ScanCodeRecordReportDto scanCodeRecordReportDto = new ScanCodeRecordReportDto();
    scanCodeRecordReportDto.setParticipatorType(loginUser.getUsertype());
    scanCodeRecordReportDto.setScanParticipatorCode(loginUser.getConsumerCode());
    Date date = new Date();
    // 1、======
    if (dateType.equals(QuantifyConstant.MONTH)) {
      scanCodeRecordReportDto.setCreateTimeStart(DateUtils.addMonths(DateUtils.ceiling(date, Calendar.MONTH), -1));
    } else {
      scanCodeRecordReportDto.setCreateTimeStart(DateUtils.addYears(DateUtils.ceiling(date,Calendar.MONTH),-1));
    }
    scanCodeRecordReportDto.setCreateTimeEnd(date);
    // 2、=====
    List<ScanCodeRecordReportVo> byConditions = this.scanCodeRecordReportVoRepository.findByConditions(scanCodeRecordReportDto);
    if (CollectionUtils.isEmpty(byConditions)) {
      return scanCodeStandardVo;
    }
    // 3、====== todo 年度的时候，后续进行定时任务跑月度标箱和标瓶
    BigDecimal inStorageStandardBottle = BigDecimal.ZERO;
    BigDecimal inStorageStandardBox = BigDecimal.ZERO;
    BigDecimal outStorageStandardBottle = BigDecimal.ZERO;
    BigDecimal outStorageStandardBox = BigDecimal.ZERO;
    for (ScanCodeRecordReportVo scanCodeRecordReportVo : byConditions) {
      if (StringUtils.isNotBlank(scanCodeRecordReportVo.getScanType()) && ScanTypeEnum.ENTER_WAREHOUSE.getCode().equals(scanCodeRecordReportVo.getScanType())) {
        inStorageStandardBox = inStorageStandardBox.add(scanCodeRecordReportVo.getStandardUnitBoxValue());
        inStorageStandardBottle = inStorageStandardBottle.add(scanCodeRecordReportVo.getStandardUnitBoxValue());
      } else {
        outStorageStandardBox = outStorageStandardBox.add(scanCodeRecordReportVo.getStandardUnitBoxValue());
        outStorageStandardBottle = outStorageStandardBottle.add(scanCodeRecordReportVo.getStandardUnitBoxValue());
      }
    }
    scanCodeStandardVo.setInStorageStandardBox(inStorageStandardBox);
    scanCodeStandardVo.setInStorageStandardBottle(inStorageStandardBottle);
    scanCodeStandardVo.setOutStorageStandardBox(outStorageStandardBox);
    scanCodeStandardVo.setOutStorageStandardBottle(outStorageStandardBottle);
    return scanCodeStandardVo;
  }
}
