package com.biz.crm.cps.mobile.terminal.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.participator.sdk.dto.TerminalPaginationDto;
import com.biz.crm.cps.business.participator.sdk.service.TerminalVoService;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardRelParticipatorServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelParticipatorItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordStatisticsDto;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.biz.crm.cps.mobile.terminal.service.TerminalManageVoService;
import com.biz.crm.cps.mobile.terminal.vo.TerminalManageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 终端管理Vo相关Service实现
 * @Author dy
 * @DATE 2022/3/24
 **/
@Service("TerminalManageVoServiceImpl")
public class TerminalManageVoServiceImpl implements TerminalManageVoService {

  @Autowired
  private TerminalVoService terminalVoService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private List<RewardRelParticipatorServiceObserver> rewardRelParticipatorServiceObserverList;
  @Autowired
  private ScanCodeRecordVoService scanCodeRecordVoService;

  @Override
  public Page<TerminalManageVo> findByConditions(Pageable pageable, TerminalPaginationDto terminalPaginationDto) {

    Page<TerminalVo> page = terminalVoService.findByConditions(pageable, terminalPaginationDto);
    if(page == null || CollectionUtils.isEmpty(page.getRecords())){
      return new Page<>();
    }
    List<TerminalVo> records = page.getRecords();
    List<String> terminalCodes = records.stream().map(TerminalVo::getTerminalCode).collect(Collectors.toList());
    List<TerminalManageVo> result = Lists.newArrayList();

    List<RewardRelParticipatorItemVo> list = Lists.newArrayList();
    if(!CollectionUtils.isEmpty(rewardRelParticipatorServiceObserverList)) {
      for (RewardRelParticipatorServiceObserver rewardRelParticipatorServiceObserver : rewardRelParticipatorServiceObserverList) {
        List<RewardRelParticipatorItemVo> rewardRelParticipatorItemVos = rewardRelParticipatorServiceObserver.onRequestRewardRelParticipatorItems(terminalCodes);
        if (!CollectionUtils.isEmpty(rewardRelParticipatorItemVos)) {
          list.addAll(rewardRelParticipatorItemVos);
        }
      }
    }
    //2汇总后按参与者分类
    Map<String, List<RewardRelParticipatorItemVo>> relMap = list.stream().filter(item -> Objects.nonNull(item.getParticipatorCode()))
        .collect(Collectors.groupingBy(RewardRelParticipatorItemVo::getParticipatorCode));
    ScanCodeRecordStatisticsDto scanCodeRecordStatisticsDto = new ScanCodeRecordStatisticsDto();
    for (TerminalVo terminalVo : records) {
      TerminalManageVo terminalManageVo = nebulaToolkitService.copyObjectByBlankList(terminalVo, TerminalManageVo.class, HashSet.class, ArrayList.class);
      if(relMap.containsKey(terminalManageVo.getTerminalCode())){
        List<RewardRelParticipatorItemVo> rewardRelParticipatorItemVos = relMap.get(terminalManageVo.getTerminalCode());
        List<RewardTypeStatisticsVo> rewardTypeStatisticsVos = rewardRelParticipatorItemVos.stream().map(RewardRelParticipatorItemVo::getRewardStatisticsVo).collect(Collectors.toList());
        terminalManageVo.setRewardTypeStatisticsVos(rewardTypeStatisticsVos);
      }
      // 查询扫码次数
      scanCodeRecordStatisticsDto.setScanParticipatorCode(terminalManageVo.getTerminalCode());
      Integer count = scanCodeRecordVoService.countByScanCodeRecordDto(scanCodeRecordStatisticsDto);
      terminalManageVo.setScanRecordCount(count == null ? BigDecimal.ZERO : BigDecimal.valueOf(count));
      result.add(terminalManageVo);
    }
    Page<TerminalManageVo> manageVoPage = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
    manageVoPage.setRecords(result);
    return manageVoPage;
  }
}
