package com.biz.crm.cps.mobile.terminal.strategy;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;

/**
 * 登录用户策略器，不同类型的用户对应不同的算法
 *
 * @author songjingen
 */
public interface LoginUserAuthenticateStrategy {

  /**
   * 登录用户的用户类型
   *
   * @return
   */
  String getUserType();

  /**
   * 触发登录用户的认证
   *
   * @param loginUserDetailsForCPS 登录信息
   * @return
   */
  void handleLoginUserAuthenticate(LoginUserDetailsForCPS loginUserDetailsForCPS);
}
