package com.biz.crm.cps.mobile.terminal.strategy.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.mobile.terminal.strategy.LoginUserAuthenticateStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author songjingen
 */
@Slf4j
@Component
public class ConsumerLoginUserAuthenticateStrategy implements LoginUserAuthenticateStrategy {

  @Override
  public String getUserType() {
    return ParticipatorTypeEnum.CONSUMER.getKey();
  }

  @Override
  public void handleLoginUserAuthenticate(LoginUserDetailsForCPS loginUserDetailsForCPS) {
    /*
     * 处理过程如下：
     * 1、首先通过手机号和用户类型、查询当前用户的存在性
     * 2、然后判断当前用户的状态是否正常
     * 3、再判断当前用户的登录密码是否正确
     */
    // 1、
//    UserVo userVo = this.userVoService.findDetailsByPhone(LoginUserDetailsForCPS.getPhone());
//    Validate.notNull(userVo, "用户不存在或已删除！");
//    // 2、
//    Validate.isTrue(EnableStatusEnum.ENABLE.getCode().equals(userVo.getEnableStatus()), "当前用户已禁用！");
//    Validate.isTrue(LockStateEnum.UNLOCK.getCode().equals(userVo.getLockState()), "当前用户已锁定！");
//    // 3、密码校验过程先按与前端约定的加密方式做解密，然后md5再做校验
//    String password = Aes128Utils.decrypt(LoginUserDetailsForCPS.getPassword(), UserConstant.ENCRYPT_KEY, Aes128Utils.
//        EncodeType.CBC, Aes128Utils.Padding.PKCS_7_PADDING);
//    log.error("password decrypt:{}", password);
//    String passwordEncryption = DigestUtils.md5DigestAsHex(password.getBytes(StandardCharsets.UTF_8));
//    Validate.isTrue(passwordEncryption.equals(userVo.getUserPassword()), "登录密码错误！");
  }
}
