package com.biz.crm.cps.mobile.terminal.strategy.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.cps.mobile.terminal.strategy.LoginUserAuthenticateStrategy;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.event.AuthenticationDecisionStrategy;
import com.bizunited.nebula.security.sdk.event.DecisionTypes;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;

import java.util.List;

/**
 * 典型的手机号+密码方式策略实现
 *
 * @author songjingen
 */
@Slf4j
@Component
public class DefaultPhoneAndPasswordStrategy implements AuthenticationDecisionStrategy {

  @Autowired(required = false)
  private List<LoginUserAuthenticateStrategy> loginUserAuthenticateStrategies;

  @Override
  public DecisionTypes type() {
    return DecisionTypes.PHONEANDPASSWORD;
  }

  @Override
  public boolean onAuthenticate(LoginDetails loginDetails) {
    //重置cookie
    RequestContextHolder.resetRequestAttributes();

    Validate.notNull(loginDetails, "未获取到登录信息！");
    Validate.isTrue(!CollectionUtils.isEmpty(loginUserAuthenticateStrategies), "未获取到登录用户策略器！");

    LoginUserDetailsForCPS loginUserDetails = (LoginUserDetailsForCPS) loginDetails;
    String phone = loginUserDetails.getPhone();
    String password = loginUserDetails.getPassword();
    String usertype = loginUserDetails.getUsertype();
    Validate.notBlank(phone, "登录手机号不能为空！");
    Validate.notBlank(password, "登录密码不能为空！");
    Validate.notBlank(usertype, "登录用户类型不能为空！");
    log.info("HttpServletRequest phone:{}", phone);
    log.info("HttpServletRequest password:{}", password);

    LoginUserAuthenticateStrategy strategy = loginUserAuthenticateStrategies.stream().filter(a -> StringUtils.equals(usertype, a.getUserType())).findFirst().orElse(null);
    Validate.notNull(strategy, "未匹配到当前用户类型【%s】的登录用户策略！", usertype);
    strategy.handleLoginUserAuthenticate(loginUserDetails);

    //设置租户信息
    loginUserDetails.setTenantCode(TenantUtils.getTenantCode());
    return true;
  }

}
