package com.biz.crm.cps.mobile.terminal.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 提现流水报表vo
 *
 * @author hecheng
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CashRecordReportVo", description = "提现流水报表vo")
public class CashRecordReportVo {

  /**
   * id
   */
  private String id;
  /**
   * 兑付流水编码
   */
  @ApiModelProperty("兑付流水编码")
  private String cashCode;

  /**
   * 兑付类型标志
   *
   * <pre>
   * "zhangfangyun":"账房云"
   * "weixinPay", "微信红包"
   * "alipay": "支付宝红包"
   * </pre>
   */
  @ApiModelProperty("兑付类型标志")
  private String cashMethodKey;

  /**
   * 兑付类型名称
   *
   * <pre>
   * "zhangfangyun":"账房云"
   * "weixinPay", "微信红包"
   * "alipay": "支付宝红包"
   * </pre>
   */
  @ApiModelProperty("兑付类型名称")
  private String cashMethodName;

  /**
   * 所属奖励标志（费用，红包，等等）
   */
  @ApiModelProperty("奖励标志（费用，红包，等等）")
  private String rewardKey;

  /**
   * 所属奖励方式名称（费用，红包，等等）
   */
  @ApiModelProperty("奖励方式名称（费用，红包，等等）")
  private String rewardName;

  /**
   * 兑付金额
   */
  @ApiModelProperty("兑付金额")
  private BigDecimal amount;

  /**
   * 兑付状态  CashStatusEnum
   */
  @ApiModelProperty("兑付状态")
  private String cashStatus;
  /**
   * 打款时间
   */
  @ApiModelProperty("打款时间")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date payDate;

  /**
   * 到账时间
   */
  @ApiModelProperty("到账时间")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date receiveDate;

  /**
   * 收款人编码 （终端用户、经销商用户、消费者openid）
   */
  @ApiModelProperty("收款人编码")
  private String payeeCode;

  /**
   * 收款人姓名
   */
  @ApiModelProperty("收款人姓名")
  private String payeeName;

  /**
   * 收款人性别
   */
  @ApiModelProperty("收款人性别")
  private String payeeSex;

  /**
   * 收款人电话
   */
  @ApiModelProperty("收款人电话")
  private String payeePhone;

  /**
   * 收款人账户 （终端用户、经销商用户、消费者openid）
   */
  @ApiModelProperty("收款人账户")
  private String payeeBank;

  /**
   * 收款人身份证背面
   */
  @ApiModelProperty("收款人身份证背面")
  private String backgroundIdCardPath;

  /**
   * 收款人身份证正面
   */
  @ApiModelProperty("收款人身份证正面")
  private String headPhotoIdCardPath;


  /**
   * 参与者编码
   */
  @ApiModelProperty("客户编码")
  private String participatorCode;

  /**
   * 参与者名称
   */
  @ApiModelProperty("客户名称")
  private String participatorName;

  /**
   * 参与者类型
   */
  @ApiModelProperty("客户类型")
  private String participatorType;
  /**
   * 所属组织
   */
  @ApiModelProperty("所属组织")
  private String orgName;
  /**
   * 所属客户组织
   */
  @ApiModelProperty("所属客户组织")
  private String customerOrganization;
  /**
   * 终端门店类型
   */
  @ApiModelProperty("终端门店类型")
  private String type;
  /**
   * 所属渠道
   */
  @ApiModelProperty("所属渠道")
  private String channelName;
  /**
   * 终端门店标签
   */
  @ApiModelProperty("终端/经销商门店标签")
  private String tags;

  /**
   * 电话
   */
  @ApiModelProperty("电话")
  private String phone;
}
