package com.biz.crm.cps.mobile.terminal.vo;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 分利消费者信息vo
 * @Author dy
 * @DATE 2022/4/1
 **/
@Data
@ApiModel("客户管理Vo")
public class ConsumerManageVo extends TenantOpVo {

  private static final long serialVersionUID = -1686615895368574540L;

  /**
   * 消费者编码
   */
  @ApiModelProperty("消费者编码")
  private String consumerCode;

  /**
   * 消费者外部id
   */
  @ApiModelProperty("消费者外部id")
  private String externalId;

  /**
   * 手机号
   */
  @ApiModelProperty("手机号")
  private String phone;

  /**
   * 昵称
   */
  @ApiModelProperty("昵称")
  private String nickname;

  /**
   * 姓名
   */
  @ApiModelProperty("姓名")
  private String fullName;

  /**
   * 累计分利金额
   */
  @ApiModelProperty("累计分利红包")
  private BigDecimal cumulativeAmount;

  /**
   * 累计分利积分
   */
  @ApiModelProperty("累计分利积分")
  private BigDecimal cumulativeIntegral;


  /**
   * 剩余分利金额
   */
  @ApiModelProperty("剩余分利红包")
  private BigDecimal remainderAmount;

  /**
   * 剩余分利积分
   */
  @ApiModelProperty("剩余分利积分")
  private BigDecimal remainderIntegral;

  /**
   * 参与次数
   */
  @ApiModelProperty("参与次数")
  private Integer participateTimes;

  /**
   * 涉及终端家数
   */
  @ApiModelProperty("涉及终端家数")
  private Integer involveTerminalCount;

  /**
   * 手机号授权时间
   */
  @ApiModelProperty("手机号授权时间")
  @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
  private Date authorizeTime;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  private String provinceCode;

  /**
   * 省名称
   */
  @ApiModelProperty("省名称")
  private String provinceName;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 市名称
   */
  @ApiModelProperty("市名称")
  private String cityName;

  /**
   * 区编码
   */
  @ApiModelProperty("区编码")
  private String districtCode;

  /**
   * 区名称
   */
  @ApiModelProperty("区名称")
  private String districtName;

  /**
   * 消费者地址
   */
  @ApiModelProperty("消费者地址")
  private String consumerAddress;

  /**
   * 新增加时间
   */
  @ApiModelProperty("新增时间")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date addTime;
}
