package com.biz.crm.cps.mobile.terminal.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 奖励报表vo
 *
 * @author sunx
 * @date 2022/3/28
 */
@Data
@ApiModel(value = "RewardReportVo", description = "奖励报表vo")
public class RewardReportVo {
  /** 奖励流水编码 */
  @ApiModelProperty("奖励流水编码")
  private String code;
  /**
   * 奖励类型
   *
   * @see RewardTypeEnum
   */
  @ApiModelProperty("奖励类型，1-红包，2-积分，3-费用，4-赠品")
  private String rewardType;
  /**
   * 参与者类型
   *
   * @see com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum
   */
  @ApiModelProperty("参与者类型,1-经销商，2-终端，3-消费者，4-导购")
  private String participatorType;
  /** 参与者编码 */
  @ApiModelProperty("参与者编码")
  private String participatorCode;
  /** 参与者名称 */
  @ApiModelProperty("参与者名称")
  private String participatorName;
  /** 电话 */
  @ApiModelProperty("电话")
  private String phone;
  /** 变动金额 */
  @ApiModelProperty("变动金额")
  private String amount;
  /** 扫码记录编码 */
  @ApiModelProperty("扫码记录编码")
  private String recordCode;
  /** 返利类型 (正向，反向) */
  @ApiModelProperty("返利类型，扫码政策分利，返利，扫码活动分利，扫码活动返利")
  private String rebateType;
  /** 返利分利 (正向，反向) */
  @ApiModelProperty("返利分利，分利-0，返利-1")
  private String type;
  /** 创建时间 */
  @ApiModelProperty("创建时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;
  /**
   * 关联业务类型
   *
   * @see RewardRelateTypeEnum dictCode
   */
  @ApiModelProperty(
      value =
          "关联业务类型 AGREEMENT(\"agreement\", \"agreement\", \"协议活动\", \"1\"),\n"
              + "  SCAN_ACTIVITY(\"scan_activity\", \"scan_activity\", \"扫码活动\", \"2\")")
  private String relateType;
  /** 关联业务流号 协议活动号、扫码活动编码 */
  @ApiModelProperty(value = "关联业务流号-协议活动号、扫码活动编码", hidden = true)
  private String relateCode;
  /** 扫码活动名称 */
  @ApiModelProperty("扫码活动名称")
  private String scanActivityName;
  /** 协议模版编码 */
  @ApiModelProperty(value = "协议模版编码", hidden = true)
  private String templateCode;
  /** 协议模版名称 */
  @ApiModelProperty("协议模版名称")
  private String templateName;
  /** 协议模版编码 */
  @ApiModelProperty("政策名称")
  private String policyName;
}
