package com.biz.crm.cps.mobile.terminal.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 扫码产品信息报表vo
 * @author songjingen
 */
@Data 
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeMaterialVo", description = "扫码产品信息报表vo")
public class ScanCodeMaterialVo {
  private static final long serialVersionUID = 2839529856499188665L;

  /**
   * 物料名称
   */
  @ApiModelProperty("物料名称")
  private String materialName;

  /**
   * 商品唯一码
   */
  @ApiModelProperty("商品唯一码")
  private String productCode;

  /**
   * 箱码的数量
   */
  @ApiModelProperty("箱码的数量")
  private BigDecimal boxCount;

  /**
   * 盒码的数量
   */
  @ApiModelProperty("盒码的数量")
  private BigDecimal bottleCount;

  /**
   * 箱码集合
   */
  @ApiModelProperty("箱码集合")
  private List<String> boxBarCodes;

  /**
   * 盒码集合
   */
  @ApiModelProperty("盒码集合")
  private List<String> bottleBarCodes;

}
