package com.biz.crm.cps.mobile.terminal.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author dy
 * @DATE 2022/4/14
 **/
@Data
@ApiModel("扫码记录")
public class ScanCodeRecordReportAllVo {

  /** 扫码记录编码 */
  @ApiModelProperty(value = "扫码记录编码")
  private String recordCode;
  /**
   * 扫码类型：1-入库，2-开单，3-抽奖
   *
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanTypeEnum
   */
  @ApiModelProperty("扫码类型：1-入库，2-开单，3-抽奖")
  private String scanType;

  /**
   * 码类型：1-箱码，2-盒码，3-盖内码
   *
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum
   */
  @ApiModelProperty("码类型：1-箱码，2-盒码，3-盖内码")
  private String barCodeType;

  /** 码 */
  @ApiModelProperty(value = "码")
  private String barCode;

  /** 物料编码 */
  @ApiModelProperty(value = "物料编码")
  private String productCode;

  /** 参与者类型：(c-经销商，terminal-终端用户，consumer-消费者) */
  @ApiModelProperty("参与者类型：(c-经销商，terminal-终端用户，consumer-消费者,user_guide-导购)")
  private String participatorType;

  /** 码流转参与者编码 */
  @ApiModelProperty("码流转参与者编码")
  private String scanParticipatorCode;

  /** 操作时间 */
  @ApiModelProperty(value = "操作时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;

  /** 物料名称 */
  @ApiModelProperty("物料名称")
  private String productName;

  /** 扫码结果 */
  @ApiModelProperty(value = "扫码结果")
  private String remark;

  /**
   * 标准单位转换结果 标箱数值
   */
  @ApiModelProperty(value = "标准单位结果标箱数值",hidden = true)
  @JsonIgnore
  private BigDecimal standardUnitBoxValue;

  /**
   * 标准单位转换结果
   */
  @ApiModelProperty(value = "标准单位结果",hidden = true)
  @JsonIgnore
  private String standardUnit;

  /**
   * 标准单位转换结果 标盒数值
   */
  @ApiModelProperty(value = "标准单位结果标盒数值",hidden = true)
  @JsonIgnore
  private BigDecimal standardUnitBottleValue;

  /**
   * 扫码预警
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum
   */
  @ApiModelProperty("扫码预警")
  private String scanCodeWarning;

  /**
   * 扫码异常：0-无，1-重复扫码，2-已扫过箱码，对应的盒码作废！，3-已扫过盒码，对应的箱码作废！
   * @see com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum
   */
  @ApiModelProperty("扫码异常")
  private String scanCodeException;
}
