package com.biz.crm.cps.mobile.terminal.vo;

import com.biz.crm.cps.business.reward.sdk.vo.RewardRelScanCodeItemVo;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeRecordVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 扫码记录报表vo
 * @author songjingen
 */
@Data 
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeRecordReportVo", description = "扫码记录报表vo")
public class ScanCodeRecordReportVo extends ScanCodeRecordVo {
  private static final long serialVersionUID = 2839529856499188665L;

  /**
   * 物料名称
   */
  @ApiModelProperty("物料名称")
  private String materialName;

  /**
   * 商品唯一码
   */
  @ApiModelProperty("商品唯一码")
  private String productCode;

  /**
   * 分利集合
   */
  @ApiModelProperty("分利集合")
  private List<RewardRelScanCodeItemVo> rewardRelScanCodeItemVos;

  /**
   * 关联协议名称
   */
  @ApiModelProperty("关联协议名称")
  private String agreementName;

  /**
   * 关联政策名称
   */
  @ApiModelProperty("关联政策名称")
  private String policyName;
}
