package com.biz.crm.cps.mobile.terminal.vo;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * H5扫码记录统计VO
 *
 * @author jerry7
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeStatisticsVo", description = "H5扫码记录统计VO")
public class ScanCodeStatisticsVo {

  /**
   * 累计箱数
   */
  @ApiModelProperty("累计箱数")
  private BigDecimal allBoxNumber = BigDecimal.ZERO;

  /**
   * 累计瓶数
   */
  private BigDecimal allBottleNumber = BigDecimal.ZERO;

  /**
   * 不合格箱数
   */
  @ApiModelProperty("合格箱数")
  private BigDecimal qualifiedBoxNumber = BigDecimal.ZERO;

  /**
   * 合格瓶数
   */
  @ApiModelProperty("合格瓶数")
  private BigDecimal qualifiedBottleNumber = BigDecimal.ZERO;

  /**
   * 不合格箱数
   */
  @ApiModelProperty("不合格箱数")
  private BigDecimal unqualifiedBoxNumber = BigDecimal.ZERO;

  /**
   * 不合格瓶数
   */
  @ApiModelProperty("不合格瓶数")
  private BigDecimal unqualifiedBottleNumber = BigDecimal.ZERO;

  /**
   * 扫码记录
   */
  @ApiModelProperty("扫码记录")
  private Page<ScanCodeRecordReportVo> recordReportVoPage;
}
