package com.biz.crm.cps.mobile.terminal.vo;

import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 终端管理Vo
 * @Author dy
 * @DATE 2022/3/24
 **/
@Data
@ApiModel("终端管理Vo")
public class TerminalManageVo {

  @ApiModelProperty("分利终端编码")
  private String terminalCode;

  @ApiModelProperty("分利终端名称")
  private String terminalName;

  @ApiModelProperty("分利终端类型")
  private String terminalType;

  @ApiModelProperty("省编码")
  private String provinceCode;

  @ApiModelProperty("省名称")
  private String provinceName;

  @ApiModelProperty("市编码")
  private String cityCode;

  @ApiModelProperty("市名称")
  private String cityName;

  @ApiModelProperty("区编码")
  private String districtCode;

  @ApiModelProperty("区名称")
  private String districtName;

  @ApiModelProperty("终端地址")
  private String terminalAddress;

  @ApiModelProperty("店招照片文件夹")
  private String shopSignPath;

  @ApiModelProperty("店招照片文件名")
  private String shopSignFilename;

  @ApiModelProperty("营业执照照片文件夹")
  private String businessLicensePath;

  @ApiModelProperty("营业执照照片文件名")
  private String businessLicenseFilename;

  @ApiModelProperty("审核状态")
  private String auditStatus;

  @ApiModelProperty("经纬度 格式（纬度,经度）")
  private String location;

  @ApiModelProperty("经度")
  private String longitude;

  @ApiModelProperty("纬度")
  private String latitude;

  @ApiModelProperty("扫码次数")
  private BigDecimal scanRecordCount;

  @ApiModelProperty("每种奖励的 获利汇总")
  private List<RewardTypeStatisticsVo> rewardTypeStatisticsVos;
}
