/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.mobile.terminal.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.local.entity.Agreement;
import com.biz.crm.cps.business.agreement.local.entity.ProfitAgreementTemplate;
import com.biz.crm.cps.business.agreement.local.entity.TemplatePolicyRelationship;
import com.biz.crm.cps.business.agreement.local.service.AgreementService;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignatoryEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementDto;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelAgreementVo;
import com.biz.crm.cps.mobile.terminal.service.AgreementReportVoService;
import com.biz.crm.cps.mobile.terminal.service.RewardRelAgreementVoService;
import com.biz.crm.cps.mobile.terminal.vo.AgreementReportVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgreementReportVoServiceImpl
implements AgreementReportVoService {
    @Autowired
    private AgreementService agreementService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private RewardRelAgreementVoService rewardRelAgreementVoService;

    @Override
    public Page<AgreementReportVo> findByConditions(Pageable pageable, AgreementDto dto) {
        LoginUserDetails loginUser;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new AgreementDto();
        }
        if (Objects.isNull(loginUser = this.loginUserService.getLoginUser())) {
            return null;
        }
        if (ParticipatorTypeEnum.DEALER.getKey().equals(loginUser.getUsertype())) {
            dto.setCustomerCode(loginUser.getConsumerCode());
        } else if (ParticipatorTypeEnum.TERMINAL.getKey().equals(loginUser.getUsertype())) {
            dto.setTerminalCode(loginUser.getConsumerCode());
        } else {
            return null;
        }
        Page byConditions = this.agreementService.findByConditions(pageable, dto);
        if (Objects.isNull(byConditions)) {
            return null;
        }
        ArrayList agreementReportVos = new ArrayList();
        List agreementList = byConditions.getRecords();
        if (!CollectionUtils.isEmpty((Collection)agreementList)) {
            List<String> templateCodes = agreementList.stream().map(Agreement::getTemplateCode).collect(Collectors.toList());
            List<RewardRelAgreementVo> rewardRelAgreementVos = this.rewardRelAgreementVoService.findByParticipatorCodeAndTemplateCodes(loginUser.getConsumerCode(), templateCodes);
            agreementList.stream().forEach(agreement -> {
                Set agreementSigns;
                List collect;
                AgreementReportVo agreementReportVo = (AgreementReportVo)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(agreement, AgreementReportVo.class, null, null, new String[0])));
                ProfitAgreementTemplate profitAgreementTemplate = agreement.getProfitAgreementTemplate();
                if (profitAgreementTemplate != null) {
                    agreementReportVo.setEffectiveStartTime(profitAgreementTemplate.getEffectiveStartTime());
                    agreementReportVo.setEffectiveEndTime(profitAgreementTemplate.getEffectiveEndTime());
                    agreementReportVo.setSignStartTime(profitAgreementTemplate.getSignStartTime());
                    agreementReportVo.setSignEndTime(profitAgreementTemplate.getSignEndTime());
                    Set templatePolicyRelationships = profitAgreementTemplate.getTemplatePolicyRelationships();
                    if (!CollectionUtils.isEmpty((Collection)templatePolicyRelationships)) {
                        collect = templatePolicyRelationships.stream().map(TemplatePolicyRelationship::getPolicyName).collect(Collectors.toList());
                        agreementReportVo.setPolicyNames(collect);
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)(agreementSigns = agreement.getAgreementSigns()))) {
                    agreementSigns.stream().forEach(agreementSign -> {
                        if (SignatoryEnum.TERMINAL.getCode().equals(agreementSign.getSignatory())) {
                            agreementReportVo.setSignTime(agreementSign.getSignDate());
                        }
                    });
                }
                if (!CollectionUtils.isEmpty((Collection)rewardRelAgreementVos) && !CollectionUtils.isEmpty(collect = rewardRelAgreementVos.stream().filter(rewardRelAgreementVo -> agreementReportVo.getTemplateCode().equals(rewardRelAgreementVo.getTemplateCode())).collect(Collectors.toList()))) {
                    agreementReportVo.setRewardStatisticsVos(((RewardRelAgreementVo)collect.get(0)).getRewardTypeStatisticsVos());
                }
                agreementReportVos.add(agreementReportVo);
            });
        }
        Page agreementVoPage = new Page();
        agreementVoPage.setCurrent(byConditions.getCurrent());
        agreementVoPage.setSize(byConditions.getSize());
        agreementVoPage.setTotal(byConditions.getTotal());
        agreementVoPage.setRecords(agreementReportVos);
        return agreementVoPage;
    }
}

