/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.mobile.terminal.service.internal;

import com.biz.crm.cps.business.reward.sdk.service.observer.RewardRelParticipatorServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelParticipatorItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelParticipatorVo;
import com.biz.crm.cps.mobile.terminal.service.RewardRelParticipatorVoService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RewardRelParticipatorVoServiceImpl
implements RewardRelParticipatorVoService {
    @Autowired(required=false)
    private List<RewardRelParticipatorServiceObserver> rewardRelParticipatorServiceObserverList;

    @Override
    public List<RewardRelParticipatorVo> findByParticipatorCodes(List<String> participatorCodes) {
        if (CollectionUtils.isEmpty(participatorCodes) || CollectionUtils.isEmpty(this.rewardRelParticipatorServiceObserverList)) {
            return null;
        }
        ArrayList relList = Lists.newArrayList();
        ArrayList list = Lists.newArrayList();
        for (RewardRelParticipatorServiceObserver rewardServiceObserver : this.rewardRelParticipatorServiceObserverList) {
            List itemRels = rewardServiceObserver.onRequestRewardRelParticipatorItems(participatorCodes);
            if (CollectionUtils.isEmpty((Collection)itemRels)) continue;
            list.addAll(itemRels);
        }
        Map<String, List<RewardRelParticipatorItemVo>> relMap = list.stream().filter(item -> Objects.nonNull(item.getParticipatorCode())).collect(Collectors.groupingBy(RewardRelParticipatorItemVo::getParticipatorCode));
        for (Map.Entry<String, List<RewardRelParticipatorItemVo>> entry : relMap.entrySet()) {
            RewardRelParticipatorVo vo = new RewardRelParticipatorVo();
            vo.setParticipatorCode(entry.getKey());
            List<RewardRelParticipatorItemVo> itemVos = entry.getValue();
            List rewardTypeStatisticsVos = itemVos.stream().map(RewardRelParticipatorItemVo::getRewardStatisticsVo).collect(Collectors.toList());
            vo.setRewardTypeStatisticsVos(rewardTypeStatisticsVos);
            relList.add(vo);
        }
        return relList;
    }
}

