/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.mobile.terminal.service.internal;

import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum;
import com.biz.crm.cps.mobile.terminal.dto.ScanCodeRecordReportDto;
import com.biz.crm.cps.mobile.terminal.repository.ScanCodeRecordReportVoRepository;
import com.biz.crm.cps.mobile.terminal.service.ScanCodeStandardVoService;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordReportVo;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeStandardVo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScanCodeStandardVoServiceImpl
implements ScanCodeStandardVoService {
    @Autowired
    private ScanCodeRecordReportVoRepository scanCodeRecordReportVoRepository;
    @Autowired
    private LoginUserService loginUserService;

    @Override
    public ScanCodeStandardVo findScanCodeStandardVoByDateType(String dateType) {
        ScanCodeStandardVo scanCodeStandardVo = new ScanCodeStandardVo();
        LoginUserDetails loginUser = this.loginUserService.getLoginUser();
        if (loginUser == null || StringUtils.isBlank((CharSequence)dateType)) {
            return scanCodeStandardVo;
        }
        ScanCodeRecordReportDto scanCodeRecordReportDto = new ScanCodeRecordReportDto();
        scanCodeRecordReportDto.setParticipatorType(loginUser.getUsertype());
        scanCodeRecordReportDto.setScanParticipatorCode(loginUser.getConsumerCode());
        Date date = new Date();
        if (dateType.equals("month")) {
            scanCodeRecordReportDto.setCreateTimeStart(DateUtils.addMonths((Date)DateUtils.ceiling((Date)date, (int)2), (int)-1));
        } else {
            scanCodeRecordReportDto.setCreateTimeStart(DateUtils.addMonths((Date)DateUtils.ceiling((Date)date, (int)1), (int)-1));
        }
        scanCodeRecordReportDto.setCreateTimeEnd(date);
        List<ScanCodeRecordReportVo> byConditions = this.scanCodeRecordReportVoRepository.findByConditions(scanCodeRecordReportDto);
        if (CollectionUtils.isEmpty(byConditions)) {
            return scanCodeStandardVo;
        }
        BigDecimal standardBottle = BigDecimal.ZERO;
        BigDecimal standardBox = BigDecimal.ZERO;
        byConditions.stream().forEach(scanCodeRecordReportVo -> {
            String barCodeType = scanCodeRecordReportVo.getBarCodeType();
            BigDecimal standardUnitValue = scanCodeRecordReportVo.getStandardUnitValue();
            if (standardUnitValue != null) {
                if (BarCodeTypeEnum.BOX.getFlag().equals(barCodeType)) {
                    standardBox.add(standardUnitValue);
                } else if (BarCodeTypeEnum.BOTTLE.getFlag().equals(barCodeType)) {
                    standardBottle.add(standardUnitValue);
                }
            }
        });
        scanCodeStandardVo.setStandardBox(standardBox);
        scanCodeStandardVo.setStandardBottle(standardBottle);
        return scanCodeStandardVo;
    }
}

