/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.mobile.terminal.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelAgreementVo;
import com.biz.crm.cps.mobile.terminal.service.RewardRelAgreementVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6309\u5206\u5229\u534f\u8bae\u6c47\u603b\u5956\u52b1\u62a5\u8868\uff08\u79fb\u52a8\u7aef\uff09"})
@RestController
@RequestMapping(value={"/v1/mobile/rewardRelAgreement"})
public class RewardRelAgreementVoController {
    private static final Logger log = LoggerFactory.getLogger(RewardRelAgreementVoController.class);
    @Autowired
    private RewardRelAgreementVoService rewardRelAgreementVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @ApiOperation(value="\u7d2f\u8ba1\u6536\u76ca\u7edf\u8ba1")
    @GetMapping(value={"/findByAgreementCodes"})
    public Result<List<RewardRelAgreementVo>> findByAgreementCodes(@RequestParam(value="agreementCodes") List<String> agreementCodes) {
        try {
            LoginUserDetails userDetails = this.loginUserService.getLoginUser();
            List<RewardRelAgreementVo> list = this.rewardRelAgreementVoService.findByParticipatorCodeAndAgreementCodes(userDetails.getConsumerCode(), agreementCodes);
            return Result.ok(list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

