/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.mobile.terminal.service.internal;

import com.biz.crm.cps.business.reward.sdk.service.observer.RewardRelAgreementServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelAgreementItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelAgreementVo;
import com.biz.crm.cps.mobile.terminal.service.RewardRelAgreementVoService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RewardRelAgreementVoServiceImpl
implements RewardRelAgreementVoService {
    @Autowired(required=false)
    private List<RewardRelAgreementServiceObserver> rewardRelAgreementServiceObservers;

    @Override
    public List<RewardRelAgreementVo> findByParticipatorCodeAndAgreementCodes(String participatorCode, List<String> agreementCodes) {
        ArrayList relList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(agreementCodes)) {
            return relList;
        }
        if (!CollectionUtils.isEmpty(this.rewardRelAgreementServiceObservers)) {
            ArrayList list = Lists.newArrayList();
            for (RewardRelAgreementServiceObserver rewardServiceObserver : this.rewardRelAgreementServiceObservers) {
                List itemRels = rewardServiceObserver.onRequestRewardRelAgreementItems(participatorCode, agreementCodes);
                list.addAll(itemRels);
            }
            Map<String, List<RewardRelAgreementItemVo>> relMap = list.stream().collect(Collectors.groupingBy(RewardRelAgreementItemVo::getAgreementCode));
            for (Map.Entry<String, List<RewardRelAgreementItemVo>> entry : relMap.entrySet()) {
                RewardRelAgreementVo vo = new RewardRelAgreementVo();
                vo.setAgreementCode(entry.getKey());
                List<RewardRelAgreementItemVo> itemVos = entry.getValue();
                List rewardTypeStatisticsVos = itemVos.stream().map(RewardRelAgreementItemVo::getRewardStatisticsVo).collect(Collectors.toList());
                vo.setRewardTypeStatisticsVos(rewardTypeStatisticsVos);
                relList.add(vo);
            }
        }
        return relList;
    }
}

