/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.mobile.terminal.service.internal;

import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardRelScanCodeServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelScanCodeItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelScanCodeVo;
import com.biz.crm.cps.mobile.terminal.service.RewardRelScanCodeVoService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RewardRelScanCodeVoServiceImpl
implements RewardRelScanCodeVoService {
    @Autowired(required=false)
    private List<RewardRelScanCodeServiceObserver> rewardRelScanCodeServiceObserverList;
    @Autowired
    private AgreementVoService agreementVoService;

    @Override
    public List<RewardRelScanCodeVo> findByParticipatorCodeAndRecordCodes(String participatorCode, String participatorType, List<String> recordCodes) {
        if (StringUtils.isEmpty((CharSequence)participatorCode) || CollectionUtils.isEmpty(recordCodes) || CollectionUtils.isEmpty(this.rewardRelScanCodeServiceObserverList)) {
            return null;
        }
        ArrayList relList = Lists.newArrayList();
        ArrayList list = Lists.newArrayList();
        for (RewardRelScanCodeServiceObserver rewardServiceObserver : this.rewardRelScanCodeServiceObserverList) {
            List rewardRelScanCodeItemVos = rewardServiceObserver.onRequestRewardRelScanCodeItems(participatorCode, recordCodes);
            if (CollectionUtils.isEmpty((Collection)rewardRelScanCodeItemVos)) continue;
            list.addAll(rewardRelScanCodeItemVos);
        }
        Map<String, List<RewardRelScanCodeItemVo>> relMap = list.stream().collect(Collectors.groupingBy(RewardRelScanCodeItemVo::getRecordCode));
        for (Map.Entry<String, List<RewardRelScanCodeItemVo>> entry : relMap.entrySet()) {
            RewardRelScanCodeVo vo = new RewardRelScanCodeVo();
            vo.setRecordCode(entry.getKey());
            List<RewardRelScanCodeItemVo> itemVos = entry.getValue();
            if (CollectionUtils.isEmpty(itemVos)) continue;
            itemVos.forEach(item -> {
                List templateCodes = item.getTemplateCodes();
                LoginUserAgreementDto dao = new LoginUserAgreementDto();
                if (Objects.equals(participatorType, ParticipatorTypeEnum.DEALER.getDictCode())) {
                    dao.setCustomerCode(participatorCode);
                } else if (Objects.equals(participatorType, ParticipatorTypeEnum.TERMINAL.getDictCode())) {
                    dao.setTerminalCode(participatorCode);
                }
                if (!CollectionUtils.isEmpty((Collection)templateCodes)) {
                    dao.setTemplateCodes((List)Lists.newArrayList((Iterable)templateCodes));
                    List agreementVos = this.agreementVoService.findByConditions(dao);
                    if (!CollectionUtils.isEmpty((Collection)agreementVos)) {
                        String agreementNames = agreementVos.stream().map(AgreementVo::getAgreementName).collect(Collectors.joining(","));
                        item.setAgreementNames(agreementNames);
                        if (!CollectionUtils.isEmpty((Collection)item.getPolicyNames())) {
                            Object[] unitArr = new String[item.getPolicyNames().size()];
                            item.getPolicyNames().toArray(unitArr);
                            String policyNameStr = StringUtils.joinWith((String)",", (Object[])unitArr);
                            item.setPolicyNameStr(policyNameStr);
                        }
                    }
                }
            });
            vo.setRewardRelScanCodeItemVos(itemVos);
            relList.add(vo);
        }
        return relList;
    }
}

