/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.mobile.terminal.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.dto.QuantifyPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyPolicy;
import com.biz.crm.cps.business.policy.quantify.local.service.QuantifyPolicyService;
import com.biz.crm.cps.business.policy.quantify.local.utils.QuantifyUtils;
import com.biz.crm.cps.business.product.sdk.service.MaterialStandardUnitVoService;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.business.product.sdk.vo.MaterialVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelScanCodeItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelScanCodeVo;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordStatisticsDto;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeRecordVo;
import com.biz.crm.cps.mobile.terminal.dto.ScanCodeRecordReportDto;
import com.biz.crm.cps.mobile.terminal.repository.ScanCodeRecordReportVoRepository;
import com.biz.crm.cps.mobile.terminal.service.RewardRelScanCodeVoService;
import com.biz.crm.cps.mobile.terminal.service.ScanCodeRecordReportVoService;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeReachVo;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordReportVo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScanCodeRecordReportVoServiceImpl
implements ScanCodeRecordReportVoService {
    @Autowired
    private ScanCodeRecordReportVoRepository scanCodeRecordReportVoRepository;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private MaterialVoService materialVoService;
    @Autowired
    private RewardRelScanCodeVoService rewardRelScanCodeVoService;
    @Autowired
    private AgreementVoService agreementVoService;
    @Autowired
    private QuantifyPolicyService quantifyPolicyService;
    @Autowired
    private ScanCodeRecordVoService scanCodeRecordVoService;
    @Autowired
    private MaterialStandardUnitVoService materialStandardUnitVoService;

    @Override
    public Page<ScanCodeRecordReportVo> findByConditions(Pageable pageable, ScanCodeRecordReportDto dto) {
        Page<ScanCodeRecordReportVo> page;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new ScanCodeRecordReportDto();
        }
        LoginUserDetails loginUser = this.loginUserService.getLoginUser();
        dto.setScanParticipatorCode(loginUser.getConsumerCode());
        dto.setParticipatorType(loginUser.getUsertype());
        if (dto.getCreateTime() != null) {
            Date start = DateUtils.addMonths((Date)DateUtils.ceiling((Date)dto.getCreateTime(), (int)2), (int)-1);
            Date end = DateUtils.addSeconds((Date)DateUtils.ceiling((Date)dto.getCreateTime(), (int)2), (int)-1);
            dto.setCreateTimeStart(start);
            dto.setCreateTimeEnd(end);
        }
        if (Objects.isNull(page = this.scanCodeRecordReportVoRepository.findByConditions(pageable, dto))) {
            return null;
        }
        List records = page.getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            Map<String, String> materialVoMap = this.findMaterialVoMapByRecords(records);
            Map<String, List<RewardRelScanCodeItemVo>> rewardVoMap = this.findRewardVoMapByRecords(records, loginUser);
            records.stream().forEach(s -> {
                s.setMaterialName((String)materialVoMap.get(s.getProductCode()));
                s.setRewardRelScanCodeItemVos((List)rewardVoMap.get(s.getRecordCode()));
            });
        }
        return page;
    }

    private Map<String, String> findMaterialVoMapByRecords(List<ScanCodeRecordReportVo> records) {
        List productCodes = records.stream().map(ScanCodeRecordReportVo::getProductCode).collect(Collectors.toList());
        List materialVos = this.materialVoService.findByMaterialCode(productCodes);
        if (CollectionUtils.isEmpty((Collection)materialVos)) {
            return new HashMap<String, String>();
        }
        Map<String, String> materialVoMap = materialVos.stream().collect(Collectors.toMap(MaterialVo::getMaterialCode, MaterialVo::getMaterialName));
        return materialVoMap;
    }

    private Map<String, List<RewardRelScanCodeItemVo>> findRewardVoMapByRecords(List<ScanCodeRecordReportVo> records, LoginUserDetails loginUser) {
        List<String> recodeCodes = records.stream().map(ScanCodeRecordVo::getRecordCode).collect(Collectors.toList());
        String dictCode = ParticipatorTypeEnum.getByKey((String)loginUser.getUsertype()).getDictCode();
        List<RewardRelScanCodeVo> rewardRelScanCodeVos = this.rewardRelScanCodeVoService.findByParticipatorCodeAndRecordCodes(loginUser.getConsumerCode(), dictCode, recodeCodes);
        if (CollectionUtils.isEmpty(rewardRelScanCodeVos)) {
            return new HashMap<String, List<RewardRelScanCodeItemVo>>();
        }
        Map<String, List<RewardRelScanCodeItemVo>> rewardVoMap = rewardRelScanCodeVos.stream().collect(Collectors.toMap(RewardRelScanCodeVo::getRecordCode, RewardRelScanCodeVo::getRewardRelScanCodeItemVos));
        return rewardVoMap;
    }

    @Override
    public ScanCodeReachVo findScanTargetAndReach(String dateType) {
        String terminalCode = this.loginUserService.getLoginUser().getConsumerCode();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{terminalCode, dateType})) {
            return null;
        }
        BigDecimal salesTarget = BigDecimal.ZERO;
        LoginUserAgreementDto loginUserAgreementDto = new LoginUserAgreementDto();
        loginUserAgreementDto.setTerminalCode(terminalCode);
        loginUserAgreementDto.setAgreementStatus(AgreementStatusEnum.EXECUTING.getCode());
        loginUserAgreementDto.setSignStatus(SignStatusEnum.SIGNED.getCode());
        List agreementVos = this.agreementVoService.findByConditions(loginUserAgreementDto);
        if (!CollectionUtils.isEmpty((Collection)agreementVos)) {
            QuantifyPolicyDto quantifyPolicyDto = new QuantifyPolicyDto();
            quantifyPolicyDto.setTemplateCodes(agreementVos.stream().map(AgreementVo::getTemplateCode).collect(Collectors.toList()));
            List quantifyPolicies = this.quantifyPolicyService.findByConditions(quantifyPolicyDto);
            Calendar calendar = Calendar.getInstance();
            int nowMonth = calendar.get(2) + 1;
            for (QuantifyPolicy policy : quantifyPolicies) {
                if (dateType.equals("month")) {
                    salesTarget = salesTarget.add(QuantifyUtils.getScaleByMonth((int)nowMonth, (QuantifyPolicy)policy));
                    continue;
                }
                salesTarget = salesTarget.add(policy.getTotalSale());
            }
        }
        ScanCodeRecordStatisticsDto scanCodeRecordStatisticsDto = new ScanCodeRecordStatisticsDto();
        if (dateType.equals("month")) {
            scanCodeRecordStatisticsDto.setCreateTimeStart(DateUtils.addMonths((Date)DateUtils.ceiling((Date)new Date(), (int)2), (int)-1));
        } else {
            scanCodeRecordStatisticsDto.setCreateTimeStart(DateUtils.addYears((Date)DateUtils.ceiling((Date)new Date(), (int)1), (int)-1));
        }
        scanCodeRecordStatisticsDto.setScanParticipatorCode(terminalCode);
        BigDecimal scanNumber = new BigDecimal(this.scanCodeRecordVoService.countByScanCodeRecordDto(scanCodeRecordStatisticsDto));
        BigDecimal reachRate = BigDecimal.ZERO;
        reachRate = salesTarget.compareTo(BigDecimal.ZERO) == 0 ? new BigDecimal(100) : scanNumber.divide(salesTarget, 2, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        ScanCodeReachVo scanCodeReachVo = new ScanCodeReachVo();
        scanCodeReachVo.setSalesTarget(salesTarget);
        scanCodeReachVo.setScanNumber(scanNumber);
        scanCodeReachVo.setReachRate(reachRate);
        return scanCodeReachVo;
    }
}

