/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.mobile.terminal.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelParticipatorVo;
import com.biz.crm.cps.mobile.terminal.service.RewardRelParticipatorVoService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6309\u53c2\u4e0e\u8005\u7edf\u8ba1\u5956\u52b1\u6c47\u603b\u62a5\u8868\uff08\u79fb\u52a8\u7aef\uff09"})
@RestController
@RequestMapping(value={"/v1/mobile/rewardRelParticipator"})
public class RewardRelParticipatorVoController {
    private static final Logger log = LoggerFactory.getLogger(RewardRelParticipatorVoController.class);
    @Autowired
    private RewardRelParticipatorVoService rewardRelParticipatorVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @ApiOperation(value="\u53c2\u4e0e\u8005\u626b\u7801\u5956\u52b1\u7edf\u8ba1")
    @GetMapping(value={"/findByParticipatorCodes"})
    public Result<List<RewardRelParticipatorVo>> findByParticipatorCodes(@RequestParam(value="participatorCodes") List<String> participatorCodes) {
        try {
            List<Object> list = Lists.newArrayList();
            if (!CollectionUtils.isEmpty(participatorCodes)) {
                list = this.rewardRelParticipatorVoService.findByParticipatorCodes(participatorCodes);
            }
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u767b\u9646\u8005 \u83b7\u5229\u7edf\u8ba1")
    @GetMapping(value={"/findByCurrentUser"})
    public Result<RewardRelParticipatorVo> findByCurrentUser() {
        try {
            LoginUserDetails userDetails = this.loginUserService.getLoginUser();
            List<RewardRelParticipatorVo> list = this.rewardRelParticipatorVoService.findByParticipatorCodes(Lists.newArrayList((Object[])new String[]{userDetails.getConsumerCode()}));
            RewardRelParticipatorVo vo = null;
            if (!CollectionUtils.isEmpty(list)) {
                vo = list.stream().findAny().orElse(null);
            }
            return Result.ok(vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

