/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.mobile.terminal.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.biz.crm.cps.mobile.terminal.service.RewardTypeStatisticsVoService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5956\u52b1\u6c47\u603b\u62a5\u8868\uff08\u79fb\u52a8\u7aef\uff09"})
@RestController
@RequestMapping(value={"/v1/mobile/rewardTypeStatistics"})
public class RewardTypeStatisticsVoController {
    private static final Logger log = LoggerFactory.getLogger(RewardTypeStatisticsVoController.class);
    @Autowired
    private RewardTypeStatisticsVoService rewardTypeStatisticsVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @ApiOperation(value="\u626b\u7801\u5956\u52b1\u7edf\u8ba1")
    @GetMapping(value={"/findByRecordCodes"})
    public Result<List<RewardTypeStatisticsVo>> findByRecordCodes(@RequestParam(value="recordCodes") List<String> recordCodes) {
        try {
            List<Object> list = Lists.newArrayList();
            if (!CollectionUtils.isEmpty(recordCodes)) {
                LoginUserDetails userDetails = this.loginUserService.getLoginUser();
                list = this.rewardTypeStatisticsVoService.findByParticipatorCodeAndRecordCodes(userDetails.getConsumerCode(), recordCodes);
            }
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

