/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.mobile.terminal.service.internal;

import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.policy.quantify.ladder.utils.QuantifyUtils;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeJudgeEnum;
import com.biz.crm.cps.mobile.terminal.dto.ScanCodeRecordReportDto;
import com.biz.crm.cps.mobile.terminal.repository.ScanCodeRecordReportVoRepository;
import com.biz.crm.cps.mobile.terminal.service.ScanCodeStandardVoService;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeRecordReportVo;
import com.biz.crm.cps.mobile.terminal.vo.ScanCodeStandardVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScanCodeStandardVoServiceImpl
implements ScanCodeStandardVoService {
    @Autowired
    private ScanCodeRecordReportVoRepository scanCodeRecordReportVoRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    public ScanCodeStandardVo findScanCodeStandardVoByDateType(String dateType) {
        return this.findScanCodeStandardVoByDateType(dateType, null);
    }

    @Override
    public ScanCodeStandardVo findScanCodeStandardVoByDateType(String dateType, String seriseCode) {
        ScanCodeStandardVo scanCodeStandardVo = new ScanCodeStandardVo();
        LoginUserDetails loginUser = this.loginUserService.getLoginUser();
        if (loginUser == null || StringUtils.isBlank((CharSequence)dateType)) {
            return scanCodeStandardVo;
        }
        ScanCodeRecordReportDto scanCodeRecordReportDto = new ScanCodeRecordReportDto();
        scanCodeRecordReportDto.setParticipatorType(loginUser.getUsertype());
        if (ParticipatorTypeEnum.DEALER.getKey().equals(loginUser.getUsertype())) {
            ArrayList judges = Lists.newArrayList();
            judges.add(ScanCodeJudgeEnum.PROFIT_OUT.getCode());
            judges.add(ScanCodeJudgeEnum.NORMAL_OUT.getCode());
            scanCodeRecordReportDto.setScanCodeJudges(judges);
        }
        scanCodeRecordReportDto.setScanParticipatorCode(loginUser.getConsumerCode());
        scanCodeRecordReportDto.setSeriseCode(seriseCode);
        Date date = new Date();
        if (dateType.equals("month")) {
            scanCodeRecordReportDto.setCreateTimeStart(DateUtils.addMonths((Date)DateUtils.ceiling((Date)date, (int)2), (int)-1));
        }
        if (dateType.equals("season")) {
            scanCodeRecordReportDto.setCreateTimeStart(QuantifyUtils.getQurterStartTime());
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            scanCodeRecordReportDto.setCreateTimeStart(this.getYearFirstDay(calendar));
        }
        scanCodeRecordReportDto.setCreateTimeEnd(date);
        List<ScanCodeRecordReportVo> byConditions = this.scanCodeRecordReportVoRepository.findByConditions(scanCodeRecordReportDto);
        if (CollectionUtils.isEmpty(byConditions)) {
            return scanCodeStandardVo;
        }
        BigDecimal standardBottle = BigDecimal.ZERO;
        BigDecimal standardBox = BigDecimal.ZERO;
        for (ScanCodeRecordReportVo vo : byConditions) {
            if (vo.getStandardUnitBoxValue() != null) {
                standardBox = standardBox.add(vo.getStandardUnitBoxValue());
            }
            if (vo.getStandardUnitBottleValue() == null) continue;
            standardBottle = standardBottle.add(vo.getStandardUnitBottleValue());
        }
        scanCodeStandardVo.setStandardBox(standardBox);
        scanCodeStandardVo.setStandardBottle(standardBottle);
        return scanCodeStandardVo;
    }

    public Date getYearFirstDay(Calendar calendar) {
        int last = calendar.getActualMinimum(6);
        calendar.set(6, last);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }
}

