package com.biz.crm.cps.business.activity.actual.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityEntity;
import com.biz.crm.cps.business.activity.actual.local.service.RewardActivityActualService;
import com.biz.crm.cps.business.activity.actual.sdk.dto.RewardActivityDto;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 活动奖励配置
 * @Author: zengxingwang
 * @Date: 2021/10/19 16:16
 */
@Api(tags = "活动奖励配置")
@Slf4j
@RestController
@RequestMapping("/v1/activity/rewardActivity")
public class  RewardActivityActualController {

  @Autowired
  private RewardActivityActualService rewardActivityService;

  /**
   * 创建活动奖励配置
   * @param rewardActivity
   * @return
   */
  @ApiOperation(value = "创建活动奖励配置")
  @PostMapping(value = "")
  public Result<RewardActivityEntity> create(@RequestBody @ApiParam(name = "rewardActivity", value = "活动奖励配置信息") RewardActivityEntity rewardActivity) {
    try {
      RewardActivityEntity current = this.rewardActivityService.create(rewardActivity);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 编辑活动奖励配置
   * @param rewardActivity
   * @return
   */
  @ApiOperation(value = "编辑活动奖励配置")
  @PatchMapping(value = "")
  public Result<RewardActivityEntity> update(@RequestBody @ApiParam(name = "rewardActivity", value = "活动奖励配置信息") RewardActivityEntity rewardActivity) {
    try {
      RewardActivityEntity current = this.rewardActivityService.update(rewardActivity);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 条件查询活动奖励配置列表
   */
  @ApiOperation(value = "条件查询活动奖励配置列表")
  @GetMapping(value="findByConditions")
  public Result<Page<RewardActivityEntity>> findByConditions(@ApiParam(name="dto" , value="查询活动奖励配置列表dto") RewardActivityDto dto,
                                                             @PageableDefault(50) Pageable pageable) {
    try {
      Page<RewardActivityEntity> page = rewardActivityService.findByConditions(dto, pageable);
      return Result.ok(page);
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据id查询详情（包括关联信息）
   */
  @ApiOperation(value = "根据id查询详情（包括关联信息）")
  @GetMapping(value="findDetailById")
  public Result<RewardActivityEntity> findDetailById(@RequestParam(value = "id") String id) {
    try {
      RewardActivityEntity current = rewardActivityService.findDetailById(id);
      return Result.ok(current);
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量根据id启用
   */
  @ApiOperation(value = "批量根据id启用")
  @PatchMapping(value="enable")
  public Result<?> enable(@RequestBody List<String> ids) {
    try {
      rewardActivityService.enable(ids);
      return Result.ok("启用成功");
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量根据id禁用
   */
  @ApiOperation(value = "批量根据id禁用")
  @PatchMapping(value="disable")
  public Result<?> disable(@RequestBody List<String> ids) {
    try {
      rewardActivityService.disable(ids);
      return Result.ok("禁用成功");
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 获取当前时间的活动（包括关联信息）
   */
  @ApiOperation(value = "获取当前时间的活动（包括关联信息）")
  @GetMapping(value="findDetailByTime")
  public Result<RewardActivityEntity> findDetailByTime(@RequestParam("productCode") String productCode) {
    try {
      RewardActivityEntity current = rewardActivityService.findDetailByTime(productCode);
      return Result.ok(current);
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }
}
